/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.able;

import android.graphics.Rect;
import android.os.Handler;
import android.os.HandlerThread;
import com.xshare.camera.Config;
import com.xshare.camera.TypeRunnable;
import com.xshare.camera.WorkThreadServer;
import com.xshare.camera.able.LighSolveAble;
import com.xshare.camera.able.PixsValuesAble;
import com.xshare.camera.able.XQRScanAbleRotate;
import com.xshare.camera.able.XQRScanCrudeAble;
import com.xshare.camera.able.XQRScanZoomAble;
import com.xshare.camera.grayscale.Dispatch;
import com.xshare.camera.grayscale.GrayScaleDispatch;
import com.xshare.camera.helper.ScanHelper;
import com.xshare.camera.zxing.core.PlanarYUVLuminanceSource;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbleManager
extends PixsValuesAble {
    private final CopyOnWriteArrayList<PixsValuesAble> ableList = new CopyOnWriteArrayList();
    private final WorkThreadServer server = WorkThreadServer.createInstance();
    private Dispatch processDispatch;
    private Handler grayProcessHandler;
    private static final long MIN_CALL_BACK_TIME = 500L;
    private volatile long mLastParseTime = 0L;

    public AbleManager(Handler handler) {
        super(handler);
        this.init();
    }

    public static AbleManager createInstance(Handler handler) {
        return new AbleManager(handler);
    }

    private void init() {
        HandlerThread grayProcessThread = new HandlerThread("GrayProcessThread", 0);
        grayProcessThread.start();
        this.grayProcessHandler = new Handler(grayProcessThread.getLooper());
        this.loadAbility();
        if (Config.hasDepencidesScale()) {
            this.processDispatch = new GrayScaleDispatch();
        }
    }

    public void loadAbility() {
        if (this.handlerHolder == null) {
            return;
        }
        if (this.handlerHolder.get() == null) {
            return;
        }
        this.ableList.clear();
        this.ableList.add(new XQRScanCrudeAble((Handler)this.handlerHolder.get()));
        this.ableList.add(new XQRScanZoomAble((Handler)this.handlerHolder.get()));
        this.ableList.add(new XQRScanAbleRotate((Handler)this.handlerHolder.get()));
        this.ableList.add(new LighSolveAble((Handler)this.handlerHolder.get()));
    }

    @Override
    public void cusAction(byte[] data, int dataWidth, int dataHeight) {
        if (this.checkCallBack()) {
            this.executeToParseWay2(data, dataWidth, dataHeight, ScanHelper.getScanByteRect(dataWidth, dataHeight));
        }
    }

    private boolean checkCallBack() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.mLastParseTime >= 500L) {
            this.mLastParseTime = currentTimeMillis;
            return true;
        }
        return false;
    }

    public void grayscaleProcess(PlanarYUVLuminanceSource source) {
        if (this.processDispatch == null) {
            return;
        }
        this.grayProcessHandler.removeCallbacksAndMessages(null);
        this.grayProcessHandler.post(() -> {
            if (this.processDispatch != null) {
                this.processDispatch.dispatch(source.getMatrix(), source.getWidth(), source.getHeight());
            }
            for (PixsValuesAble able : this.ableList) {
                if (!able.isCycleRun(false)) continue;
                this.server.post(TypeRunnable.create(able.isImportant(false), 1, source.getTagId(), () -> able.needParseDeploy(source, false)));
            }
        });
    }

    private void originProcess(ArrayList<TypeRunnable> typeRunList) {
        for (TypeRunnable item : typeRunList) {
            this.server.post(item);
        }
    }

    private void originProcess(PlanarYUVLuminanceSource source, byte[] data, int dataWidth, int dataHeight) {
        for (PixsValuesAble able : this.ableList) {
            if (!able.isCycleRun(true)) continue;
            this.server.post(TypeRunnable.create(able.isImportant(true), 0, source.getTagId(), () -> {
                able.cusAction(data, dataWidth, dataHeight, true);
                able.needParseDeploy(source, true);
            }));
        }
    }

    private void executeToParseWay2(byte[] data, int dataWidth, int dataHeight, Rect rect) {
        PlanarYUVLuminanceSource oriSource = this.generateGlobeYUVLuminanceSource(data, dataWidth, dataHeight, rect);
        if (oriSource == null) {
            return;
        }
        this.originProcess(oriSource, data, dataWidth, dataHeight);
    }

    private PlanarYUVLuminanceSource generateGlobeYUVLuminanceSource(byte[] data, int dataWidth, int dataHeight, Rect rect) {
        return ScanHelper.buildLuminanceSource(data, dataWidth, dataHeight, rect);
    }

    @Override
    public void release() {
        super.release();
        this.grayProcessHandler.removeCallbacksAndMessages(null);
        this.grayProcessHandler.getLooper().quit();
        for (PixsValuesAble able : this.ableList) {
            able.release();
        }
        this.ableList.clear();
        this.server.quit();
    }

    public void clear() {
        this.server.clear();
        this.ableList.clear();
    }
}

