/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.able;

import android.os.Handler;
import com.xshare.camera.able.PixsValuesAble;
import com.xshare.camera.helper.LightHelper;

public class LighSolveAble
extends PixsValuesAble {
    private int STANDVALUES = 100;
    private boolean isBright = true;
    static long lastRecordTime = System.currentTimeMillis();
    static int waitScanTime = 1000;

    public LighSolveAble(Handler handler) {
        super(handler);
    }

    @Override
    protected void cusAction(byte[] data, int dataWidth, int dataHeight, boolean isNative) {
        super.cusAction(data, dataWidth, dataHeight, isNative);
        if (!isNative) {
            return;
        }
        int avDark = LightHelper.getAvDark(data, dataWidth, dataHeight);
        if (avDark > this.STANDVALUES && !this.isBright) {
            this.isBright = true;
            this.sendMessage(1, true);
        }
        if (avDark < this.STANDVALUES && this.isBright) {
            this.isBright = false;
            this.sendMessage(1, false);
        }
    }

    @Override
    public boolean isCycleRun(boolean isNative) {
        if (!isNative) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRecordTime < (long)waitScanTime) {
            return false;
        }
        lastRecordTime = currentTime;
        return true;
    }

    @Override
    public boolean isImportant(boolean isNative) {
        return isNative;
    }
}

