/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.able;

import android.os.Handler;
import com.xshare.camera.Config;
import com.xshare.camera.able.XQRScanAble;
import com.xshare.camera.helper.ScanHelper;
import com.xshare.camera.zxing.core.PlanarYUVLuminanceSource;
import com.xshare.camera.zxing.core.ResultPoint;

public class XQRScanZoomAble
extends XQRScanAble {
    long zoomTime = 0L;
    int lastLenght = 0;

    XQRScanZoomAble(Handler handler) {
        super(handler);
    }

    @Override
    protected void needParseDeploy(PlanarYUVLuminanceSource source, boolean isNative) {
        super.needParseDeploy(source, isNative);
        if (this.result == null) {
            return;
        }
        ResultPoint[] points = this.result.getResultPoints();
        if (points == null || points.length < 3) {
            return;
        }
        int lenght = ScanHelper.getQrLenght(points);
        if (points != null && points.length >= 3) {
            this.sendMessage(3, ScanHelper.rotatePoint(points));
        }
        if (System.currentTimeMillis() - this.zoomTime < 500L) {
            return;
        }
        if ((float)lenght < (float)this.lastLenght * 0.8f) {
            Config.currentZoom = 0.0f;
        } else if (lenght < Config.scanRect.getPreX() / 3 * 2) {
            Config.currentZoom = (float)((double)Config.currentZoom + 0.07);
        }
        this.zoomTime = System.currentTimeMillis();
        this.lastLenght = lenght;
        this.sendMessage(2, Config.currentZoom + "");
    }
}

