/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.camera;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import androidx.collection.SparseArrayCompat;
import com.xshare.camera.camera.AspectRatio;
import com.xshare.camera.camera.CameraViewImpl;
import com.xshare.camera.camera.Constants;
import com.xshare.camera.camera.PreviewImpl;
import com.xshare.camera.camera.Size;
import com.xshare.camera.camera.SizeMap;
import com.xshare.camera.helper.CameraHelper;
import com.xshare.camera.helper.LightHelper;
import com.xshare.camera.helper.ScanHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class Camera1
extends CameraViewImpl {
    private static final int INVALID_CAMERA_ID = -1;
    private static final String TAG = "Camera1";
    private static final SparseArrayCompat<String> FLASH_MODES = new SparseArrayCompat();
    private int mCameraId;
    private final AtomicBoolean isPictureCaptureInProgress = new AtomicBoolean(false);
    volatile Camera mCamera;
    private Camera.Parameters mCameraParameters;
    private final Camera.CameraInfo mCameraInfo = new Camera.CameraInfo();
    private final SizeMap mPreviewSizes = new SizeMap();
    private final SizeMap mPictureSizes = new SizeMap();
    private AspectRatio mAspectRatio;
    private boolean mShowingPreview;
    private boolean mAutoFocus;
    private int mFacing;
    private int mFlash;
    private int mDisplayOrientation;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;

    public Camera1(CameraViewImpl.Callback callback) {
        super(callback);
    }

    @Override
    public void updatePreView(PreviewImpl preview) {
        super.updatePreView(preview);
        this.mPreview.setCallback(() -> {
            if (this.mCamera != null) {
                this.setUpPreview();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        Log.d((String)TAG, (String)"start");
        Class<Camera1> clazz = Camera1.class;
        synchronized (Camera1.class) {
            if (this.isCameraOpened()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            this.chooseCamera();
            Log.d((String)TAG, (String)"start mPreview.isReady() = false");
            if (this.mCameraId == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            Log.d((String)TAG, (String)"start mPreview.isReady() = false");
            if (!this.openCamera()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            Log.d((String)TAG, (String)"start mPreview.isReady() = false");
            if (null == this.mPreview) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            Log.d((String)TAG, (String)("start mPreview.isReady() = " + this.mPreview.isReady()));
            if (this.mPreview.isReady()) {
                this.setUpPreview();
            }
            this.mShowingPreview = true;
            if (this.mCamera != null) {
                try {
                    this.mCamera.startPreview();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Log.d((String)TAG, (String)"stop");
        Class<Camera1> clazz = Camera1.class;
        synchronized (Camera1.class) {
            if (this.mCamera != null) {
                this.mCamera.stopPreview();
                this.mCamera.setPreviewCallback(null);
            }
            this.mShowingPreview = false;
            this.releaseCamera();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    void setUpPreview() {
        Class<Camera1> clazz = Camera1.class;
        synchronized (Camera1.class) {
            if (this.mCamera == null || this.mPreview == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                    this.mCamera.setPreviewDisplay(this.mPreview.getSurfaceHolder());
                } else {
                    this.mCamera.setPreviewTexture((SurfaceTexture)this.mPreview.getSurfaceTexture());
                }
                this.mCamera.setPreviewCallback((data, camera) -> this.mCallback.onPreviewByte(data));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public boolean isCameraOpened() {
        return this.mCamera != null;
    }

    @Override
    public void setFacing(int facing) {
        if (this.mFacing == facing) {
            return;
        }
        this.mFacing = facing;
        if (this.isCameraOpened()) {
            this.stop();
            this.start();
        }
    }

    @Override
    public int getFacing() {
        return this.mFacing;
    }

    @Override
    public Set<AspectRatio> getSupportedAspectRatios() {
        SizeMap idealAspectRatios = this.mPreviewSizes;
        for (AspectRatio aspectRatio : idealAspectRatios.ratios()) {
            if (this.mPictureSizes.sizes(aspectRatio) != null) continue;
            idealAspectRatios.remove(aspectRatio);
        }
        return idealAspectRatios.ratios();
    }

    @Override
    public boolean setAspectRatio(AspectRatio ratio) {
        this.mAspectRatio = ratio;
        return true;
    }

    @Override
    public AspectRatio getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    public void setAutoFocus(boolean autoFocus) {
        if (this.mAutoFocus == autoFocus) {
            return;
        }
        if (this.setAutoFocusInternal(autoFocus)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    public boolean getAutoFocus() {
        if (!this.isCameraOpened()) {
            return this.mAutoFocus;
        }
        String focusMode = this.mCameraParameters != null ? this.mCameraParameters.getFocusMode() : null;
        return focusMode != null && focusMode.contains("continuous");
    }

    @Override
    public void setFlash(int flash) {
        if (flash == this.mFlash) {
            return;
        }
        if (this.setFlashInternal(flash)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    public int getFlash() {
        return this.mFlash;
    }

    @Override
    public void takePicture() {
        if (!this.isCameraOpened()) {
            return;
        }
        if (this.getAutoFocus()) {
            this.mCamera.cancelAutoFocus();
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    Camera1.this.takePictureInternal();
                }
            });
        } else {
            this.takePictureInternal();
        }
    }

    void takePictureInternal() {
        if (!this.isPictureCaptureInProgress.getAndSet(true)) {
            this.mCamera.takePicture(null, null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Camera1.this.isPictureCaptureInProgress.set(false);
                    Camera1.this.mCallback.onPictureTaken(data);
                    if (Camera1.this.isCameraOpened()) {
                        camera.cancelAutoFocus();
                        camera.startPreview();
                    }
                }
            });
        }
    }

    @Override
    public void setDisplayOrientation(int displayOrientation) {
        if (this.mDisplayOrientation == displayOrientation) {
            return;
        }
        if (this.mPreview != null) {
            this.mPreview.setDisplayOrientation(displayOrientation);
        }
    }

    @Override
    public void toZoomMax() {
        this.setZoom(1.0f);
    }

    @Override
    public void toZoomMin() {
        this.setZoom(0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZoom(float percent) {
        Class<Camera1> clazz = Camera1.class;
        synchronized (Camera1.class) {
            CameraHelper.setZoom(percent, this.mCamera);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lightOperator(boolean isOpen) {
        Class<Camera1> clazz = Camera1.class;
        synchronized (Camera1.class) {
            LightHelper.openLight(this.mCamera, isOpen);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void chooseCamera() {
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.mCameraInfo);
            if (this.mCameraInfo.facing != this.mFacing) continue;
            this.mCameraId = i;
            return;
        }
        this.mCameraId = -1;
    }

    private boolean openCamera() {
        if (this.mCamera != null) {
            this.releaseCamera();
        }
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (Exception e) {
            return false;
        }
        if (this.mCamera == null) {
            return false;
        }
        this.mCameraParameters = this.mCamera.getParameters();
        this.mPreviewSizes.clear();
        for (Camera.Size size : this.mCameraParameters.getSupportedPreviewSizes()) {
            this.mPreviewSizes.add(new Size(size.width, size.height));
        }
        this.mPictureSizes.clear();
        for (Camera.Size size : this.mCameraParameters.getSupportedPictureSizes()) {
            this.mPictureSizes.add(new Size(size.width, size.height));
        }
        for (AspectRatio ratio : this.mPreviewSizes.ratios()) {
            if (this.mPictureSizes.ratios().contains(ratio)) continue;
            this.mPreviewSizes.remove(ratio);
        }
        if (this.mAspectRatio == null) {
            this.mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
        }
        try {
            this.adjustCameraParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mCamera.setDisplayOrientation(this.calcDisplayOrientation(this.mDisplayOrientation));
        if (this.mCallback != null) {
            this.mCallback.onCameraOpened();
        }
        return true;
    }

    void adjustCameraParameters() {
        if (this.mPictureSizes.ratios().size() == 0) {
            return;
        }
        SortedSet<Size> sizes = this.mPreviewSizes.sizes(this.mAspectRatio);
        if (sizes == null) {
            this.mAspectRatio = AspectRatio.of(4, 3);
            if (this.mPreviewSizes.sizes(this.mAspectRatio) == null) {
                this.mAspectRatio = this.findNeartoDefaultAspectRatio(this.mPreviewSizes);
            }
            this.mPreview.updateAspectRatio(this.mAspectRatio);
            sizes = this.mPreviewSizes.sizes(this.mAspectRatio);
        }
        Size size = this.chooseOptimalSize(sizes);
        Size pictureSize = this.mPictureSizes.sizes(this.mAspectRatio).last();
        if (this.mShowingPreview) {
            this.mCamera.stopPreview();
        }
        this.mPreview.setBufferSize(size.getWidth(), size.getHeight());
        this.mCameraParameters.setPreviewSize(size.getWidth(), size.getHeight());
        this.mCameraParameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        this.mCameraParameters.setRotation(this.calcCameraRotation(this.mDisplayOrientation));
        this.setAutoFocusInternal(this.mAutoFocus);
        this.setFlashInternal(this.mFlash);
        this.mCamera.setParameters(this.mCameraParameters);
        if (this.mShowingPreview) {
            this.mCamera.startPreview();
        }
    }

    private AspectRatio findNeartoDefaultAspectRatio(SizeMap sizeMap) {
        float minRation = Float.MAX_VALUE;
        AspectRatio minAspectRatio = sizeMap.ratios().iterator().next();
        for (AspectRatio ratio : sizeMap.ratios()) {
            for (Size size : this.mPreviewSizes.sizes(ratio)) {
                float currentRatio = Math.abs(1.0f - (float)size.getWidth() / 1920.0f * ((float)size.getHeight() / 1080.0f));
                if (!(currentRatio < minRation)) continue;
                minRation = currentRatio;
                minAspectRatio = ratio;
            }
        }
        return minAspectRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Size chooseOptimalSize(SortedSet<Size> sizes) {
        int desiredHeight;
        int desiredWidth;
        int surfaceWidth = this.mPreview.getWidth();
        int surfaceHeight = this.mPreview.getHeight();
        if (surfaceWidth == 0 || surfaceHeight == 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                surfaceWidth = this.mPreview.getWidth();
                surfaceHeight = this.mPreview.getHeight();
            }
        }
        if (surfaceWidth == 0 || surfaceHeight == 0) {
            surfaceWidth = 1080;
            surfaceHeight = 1920;
        }
        if (this.isLandscape(this.mDisplayOrientation)) {
            desiredWidth = surfaceHeight;
            desiredHeight = surfaceWidth;
        } else {
            desiredWidth = surfaceWidth;
            desiredHeight = surfaceHeight;
        }
        float minRation = Float.MAX_VALUE;
        Size suitSize = null;
        for (Size size : sizes) {
            float currentRation = Math.abs(1.0f - (float)desiredWidth / (float)size.getWidth() * (float)desiredHeight / (float)size.getHeight());
            if (!(currentRation < minRation)) continue;
            minRation = currentRation;
            suitSize = size;
        }
        return suitSize;
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            Camera temp = this.mCamera;
            this.mCamera = null;
            temp.release();
            if (this.mCallback != null) {
                this.mCallback.onCameraClosed();
            }
        }
    }

    private int calcDisplayOrientation(int screenOrientationDegrees) {
        if (this.mCameraInfo.facing == 1) {
            return (360 - (this.mCameraInfo.orientation + screenOrientationDegrees) % 360) % 360;
        }
        return (this.mCameraInfo.orientation - screenOrientationDegrees + 360) % 360;
    }

    private int calcCameraRotation(int screenOrientationDegrees) {
        if (this.mCameraInfo.facing == 1) {
            return (this.mCameraInfo.orientation + screenOrientationDegrees) % 360;
        }
        int landscapeFlip = this.isLandscape(screenOrientationDegrees) ? 180 : 0;
        return (this.mCameraInfo.orientation + screenOrientationDegrees + landscapeFlip) % 360;
    }

    private boolean isLandscape(int orientationDegrees) {
        return orientationDegrees == 90 || orientationDegrees == 270;
    }

    private boolean setAutoFocusInternal(boolean autoFocus) {
        this.mAutoFocus = autoFocus;
        if (this.isCameraOpened()) {
            List modes = this.mCameraParameters.getSupportedFocusModes();
            if (autoFocus && modes.contains("continuous-picture")) {
                this.mCameraParameters.setFocusMode("continuous-picture");
            } else if (modes.contains("fixed")) {
                this.mCameraParameters.setFocusMode("fixed");
            } else if (modes.contains("infinity")) {
                this.mCameraParameters.setFocusMode("infinity");
            } else {
                this.mCameraParameters.setFocusMode((String)modes.get(0));
            }
            return true;
        }
        return false;
    }

    private boolean setFlashInternal(int flash) {
        if (this.isCameraOpened()) {
            List modes = this.mCameraParameters.getSupportedFlashModes();
            String mode = (String)FLASH_MODES.get(flash);
            if (modes != null && modes.contains(mode)) {
                this.mCameraParameters.setFlashMode(mode);
                this.mFlash = flash;
                return true;
            }
            String currentMode = (String)FLASH_MODES.get(this.mFlash);
            if (modes == null || !modes.contains(currentMode)) {
                this.mCameraParameters.setFlashMode("off");
                this.mFlash = 0;
                return true;
            }
            return false;
        }
        this.mFlash = flash;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rectMeteringWithFocus(RectF rectF) {
        Class<Camera1> clazz = Camera1.class;
        synchronized (Camera1.class) {
            if (this.mCamera == null || this.mCamera.getParameters() == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.mCamera.getParameters().getMaxNumMeteringAreas() == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (rectF == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            RectF cropRect = ScanHelper.copyRect(rectF);
            cropRect.left += (cropRect.right - cropRect.left) / 4.0f;
            cropRect.right -= (cropRect.right - cropRect.left) / 4.0f;
            cropRect.top += (cropRect.bottom - cropRect.top) / 4.0f;
            cropRect.bottom -= (cropRect.bottom - cropRect.top) / 4.0f;
            int left = (int)(2000.0f * cropRect.top) - 1000;
            int top = (int)(2000.0f * (1.0f - cropRect.right)) - 1000;
            int right = (int)(2000.0f * cropRect.bottom) - 1000;
            int bottom = (int)(2000.0f * (1.0f - cropRect.left)) - 1000;
            Rect realRect = new Rect(left, top, right, bottom);
            List<Camera.Area> areas = Collections.singletonList(new Camera.Area(realRect, 1000));
            this.mCameraParameters.setFocusAreas(areas);
            this.mCameraParameters.setMeteringAreas(areas);
            try {
                this.mCamera.setParameters(this.mCameraParameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    static {
        FLASH_MODES.put(0, (Object)"off");
        FLASH_MODES.put(1, (Object)"on");
        FLASH_MODES.put(2, (Object)"torch");
        FLASH_MODES.put(3, (Object)"auto");
        FLASH_MODES.put(4, (Object)"red-eye");
    }
}

