/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.camera;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.xshare.base.BaseApplication;
import com.xshare.camera.camera.AspectRatio;
import com.xshare.camera.camera.CameraViewImpl;
import com.xshare.camera.camera.Constants;
import com.xshare.camera.camera.PreviewImpl;
import com.xshare.camera.camera.Size;
import com.xshare.camera.camera.SizeMap;
import com.xshare.camera.helper.CameraHelper;
import com.xshare.camera.helper.ScanHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;

@RequiresApi(api=21)
public class Camera2
extends CameraViewImpl {
    private static final String TAG = "Camera2_Self";
    private static final SparseIntArray INTERNAL_FACINGS = new SparseIntArray();
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private CameraManager mCameraManager;
    private CameraDevice.StateCallback mCameraDeviceCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
            Camera2.this.mCamera = camera;
            Log.d((String)Camera2.TAG, (String)"Camera2 onOpened ");
            if (null != Camera2.this.mCallback) {
                Camera2.this.mCallback.onCameraOpened();
            }
            Camera2.this.startCaptureSession();
        }

        public void onClosed(@NonNull CameraDevice camera) {
            Log.d((String)Camera2.TAG, (String)"Camera2 onClosed ");
            if (Camera2.this.mCallback != null) {
                Camera2.this.mCallback.onCameraClosed();
            }
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            Log.d((String)Camera2.TAG, (String)"Camera2 onDisconnected ");
            Camera2.this.mCamera = null;
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            Log.d((String)Camera2.TAG, (String)("Camera2 onError error = " + error));
            Camera2.this.mCamera = null;
            Camera2.this.restart();
        }
    };
    private CameraCaptureSession.StateCallback mSessionCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(@NonNull CameraCaptureSession session) {
            if (!Camera2.this.isCameraOpened()) {
                return;
            }
            Camera2.this.mCaptureSession = session;
            Camera2.this.updateAutoFocus();
            Camera2.this.updateFlash();
            try {
                CaptureRequest request = Camera2.this.mPreviewRequestBuilder.build();
                Camera2.this.mCaptureSession.setRepeatingRequest(request, (CameraCaptureSession.CaptureCallback)Camera2.this.mCaptureCallback, null);
            }
            catch (Exception e) {
                Camera2.this.restart();
            }
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            Camera2.this.restart();
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
            if (Camera2.this.mCaptureSession != null && Camera2.this.mCaptureSession.equals(session)) {
                Camera2.this.mCaptureSession = null;
            }
        }
    };
    PictureCaptureCallback mCaptureCallback = new PictureCaptureCallback(){

        @Override
        public void onPrecaptureRequired() {
            Camera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.setState(3);
            try {
                Camera2.this.mCaptureSession.capture(Camera2.this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this, null);
                Camera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
            }
            catch (Exception e) {
                Camera2.this.restart();
            }
        }

        @Override
        public void onReady() {
            Camera2.this.captureStillPicture();
        }
    };
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = reader -> {
        try (Image image = reader.acquireNextImage();){
            Image.Plane[] planes = image.getPlanes();
            if (planes.length > 0) {
                ByteBuffer buffer = planes[0].getBuffer();
                byte[] data = new byte[buffer.remaining()];
                buffer.get(data);
                this.mCallback.onPictureTaken(data);
            }
        }
    };
    private String mCameraId;
    private CameraCharacteristics mCameraCharacteristics;
    volatile CameraDevice mCamera;
    CameraCaptureSession mCaptureSession;
    CaptureRequest.Builder mPreviewRequestBuilder;
    private ImageReader mImageReader;
    private ImageReader mYuvReader;
    private final SizeMap mPreviewSizes = new SizeMap();
    private final SizeMap mPictureSizes = new SizeMap();
    private int mFacing;
    private AspectRatio mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
    private boolean mAutoFocus;
    private int mFlash;
    private int mDisplayOrientation;
    private final ImageReader.OnImageAvailableListener mOnYuvAvailableListener = reader -> this.mCallback.onPreviewByte(CameraHelper.readYuv(reader));
    RectF rectF;

    public Camera2(CameraViewImpl.Callback callback, Context context) {
        super(callback);
        this.mCameraManager = (CameraManager)BaseApplication.baseApplication.getSystemService("camera");
    }

    @Override
    public void updatePreView(PreviewImpl preview) {
        super.updatePreView(preview);
        Log.d((String)TAG, (String)"updatePreView");
        this.mPreview.setCallback(this::startCaptureSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        Log.d((String)TAG, (String)"start");
        Class<Camera2> clazz = Camera2.class;
        synchronized (Camera2.class) {
            if (this.isCameraOpened()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            if (!this.chooseCameraIdByFacing()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            if (!this.collectCameraInfo()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            if (!this.prepareImageReader()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.startOpeningCamera();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Log.d((String)TAG, (String)"stop");
        Class<Camera2> clazz = Camera2.class;
        synchronized (Camera2.class) {
            try {
                if (this.mCaptureSession != null) {
                    this.mCaptureSession.stopRepeating();
                    this.mCaptureSession.abortCaptures();
                    this.mCaptureSession.close();
                    this.mCaptureSession = null;
                }
                if (this.mCamera != null) {
                    CameraDevice temp = this.mCamera;
                    this.mCamera = null;
                    temp.close();
                }
                if (this.mImageReader != null) {
                    this.mImageReader.close();
                    this.mImageReader = null;
                }
                if (this.mYuvReader != null) {
                    this.mYuvReader.close();
                    this.mYuvReader = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    @Override
    public boolean isCameraOpened() {
        return this.mCamera != null;
    }

    @Override
    public void setFacing(int facing) {
        if (this.mFacing == facing) {
            return;
        }
        this.mFacing = facing;
        if (this.isCameraOpened()) {
            this.restart();
        }
    }

    @Override
    public int getFacing() {
        return this.mFacing;
    }

    @Override
    public Set<AspectRatio> getSupportedAspectRatios() {
        return this.mPreviewSizes.ratios();
    }

    @Override
    public boolean setAspectRatio(AspectRatio ratio) {
        this.mAspectRatio = ratio;
        return true;
    }

    @Override
    public AspectRatio getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    public void setAutoFocus(boolean autoFocus) {
        if (this.mAutoFocus == autoFocus) {
            return;
        }
        this.mAutoFocus = autoFocus;
        if (this.mPreviewRequestBuilder != null) {
            this.updateAutoFocus();
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
                }
                catch (Exception e) {
                    this.mAutoFocus = !this.mAutoFocus;
                    this.restart();
                }
            }
        }
    }

    @Override
    public boolean getAutoFocus() {
        return this.mAutoFocus;
    }

    @Override
    public void setFlash(int flash) {
        if (this.mFlash == flash) {
            return;
        }
        int saved = this.mFlash;
        this.mFlash = flash;
        if (this.mPreviewRequestBuilder != null) {
            this.updateFlash();
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
                }
                catch (Exception e) {
                    this.mFlash = saved;
                    this.restart();
                }
            }
        }
    }

    @Override
    public int getFlash() {
        return this.mFlash;
    }

    @Override
    public void takePicture() {
        if (this.mAutoFocus) {
            this.lockFocus();
        } else {
            this.captureStillPicture();
        }
    }

    @Override
    public void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
        if (this.mPreview != null) {
            this.mPreview.setDisplayOrientation(this.mDisplayOrientation);
        }
    }

    @Override
    public void toZoomMax() {
        this.setZoom(1.0f);
    }

    @Override
    public void toZoomMin() {
        this.setZoom(0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZoom(float percent) {
        Class<Camera2> clazz = Camera2.class;
        synchronized (Camera2.class) {
            if (!this.isCameraOpened()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            try {
                Rect showRect = CameraHelper.getZoomRect(this.mCameraCharacteristics, percent);
                this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)showRect);
                this.rectMeteringWithFocus(showRect);
            }
            catch (Exception e) {
                this.restart();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lightOperator(boolean isOpen) {
        Class<Camera2> clazz = Camera2.class;
        synchronized (Camera2.class) {
            if (!this.isCameraOpened()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (isOpen) {
                this.setFlash(2);
            } else {
                this.setFlash(0);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean chooseCameraIdByFacing() {
        try {
            int internalFacing = INTERNAL_FACINGS.get(this.mFacing);
            String[] ids = this.mCameraManager.getCameraIdList();
            if (ids.length == 0) {
                return false;
            }
            for (String id : ids) {
                CameraCharacteristics characteristics = this.mCameraManager.getCameraCharacteristics(id);
                Integer level = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (level == null || level == 2) continue;
                Integer internal = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (internal == null) {
                    return false;
                }
                if (internal != internalFacing) continue;
                this.mCameraId = id;
                this.mCameraCharacteristics = characteristics;
                return true;
            }
            this.mCameraId = ids[0];
            this.mCameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCameraId);
            Integer level = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (level == null || level == 2) {
                return false;
            }
            Integer internal = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
            if (internal == null) {
                return false;
            }
            int count = INTERNAL_FACINGS.size();
            for (int i = 0; i < count; ++i) {
                if (INTERNAL_FACINGS.valueAt(i) != internal.intValue()) continue;
                this.mFacing = INTERNAL_FACINGS.keyAt(i);
                return true;
            }
            this.mFacing = 0;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean collectCameraInfo() {
        StreamConfigurationMap map = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            return false;
        }
        if (null == this.mPreview) {
            return false;
        }
        this.mPreviewSizes.clear();
        for (android.util.Size size : map.getOutputSizes(this.mPreview.getOutputClass())) {
            int width = size.getWidth();
            int height = size.getHeight();
            this.mPreviewSizes.add(new Size(width, height));
        }
        this.mPictureSizes.clear();
        for (android.util.Size size : map.getOutputSizes(256)) {
            this.mPictureSizes.add(new Size(size.getWidth(), size.getHeight()));
        }
        for (AspectRatio ratio : this.mPreviewSizes.ratios()) {
            if (this.mPictureSizes.ratios().contains(ratio)) continue;
            this.mPreviewSizes.remove(ratio);
        }
        if (!this.mPreviewSizes.ratios().contains(this.mAspectRatio)) {
            this.mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
            if (!this.mPreviewSizes.ratios().contains(this.mAspectRatio)) {
                this.mAspectRatio = this.findNeartoDefaultAspectRatio(this.mPreviewSizes);
                this.mPreview.updateAspectRatio(this.mAspectRatio);
                return true;
            }
            this.mPreview.updateAspectRatio(this.mAspectRatio);
            return true;
        }
        return true;
    }

    private AspectRatio findNeartoDefaultAspectRatio(SizeMap sizeMap) {
        float minRation = Float.MAX_VALUE;
        AspectRatio minAspectRatio = sizeMap.ratios().iterator().next();
        for (AspectRatio ratio : sizeMap.ratios()) {
            for (Size size : this.mPreviewSizes.sizes(ratio)) {
                float currentRatio = Math.abs(1.0f - (float)size.getWidth() / 1920.0f * ((float)size.getHeight() / 1080.0f));
                if (!(currentRatio < minRation)) continue;
                minRation = currentRatio;
                minAspectRatio = ratio;
            }
        }
        return minAspectRatio;
    }

    private boolean prepareImageReader() {
        try {
            if (this.mImageReader != null) {
                this.mImageReader.close();
            }
            Size largest = this.mPictureSizes.sizes(this.mAspectRatio).last();
            this.mImageReader = ImageReader.newInstance((int)largest.getWidth(), (int)largest.getHeight(), (int)256, (int)2);
            this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean startOpeningCamera() {
        Log.d((String)TAG, (String)"startOpeningCamera");
        try {
            this.mCameraManager.openCamera(this.mCameraId, this.mCameraDeviceCallback, null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCaptureSession() {
        Log.d((String)TAG, (String)"startCaptureSession ");
        try {
            Class<Camera2> clazz = Camera2.class;
            synchronized (Camera2.class) {
                if (!this.isCameraOpened() || !this.mPreview.isReady() || this.mImageReader == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                Size previewSize = this.chooseOptimalSize();
                this.mYuvReader = ImageReader.newInstance((int)previewSize.getWidth(), (int)previewSize.getHeight(), (int)35, (int)2);
                this.mYuvReader.setOnImageAvailableListener(this.mOnYuvAvailableListener, null);
                this.mPreview.setBufferSize(previewSize.getWidth(), previewSize.getHeight());
                Surface surface = this.mPreview.getSurface();
                this.mPreviewRequestBuilder = this.mCamera.createCaptureRequest(1);
                this.mPreviewRequestBuilder.addTarget(surface);
                this.mPreviewRequestBuilder.addTarget(this.mYuvReader.getSurface());
                this.mCamera.createCaptureSession(Arrays.asList(surface, this.mImageReader.getSurface(), this.mYuvReader.getSurface()), this.mSessionCallback, null);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("startCaptureSession Exception restart :" + e.getMessage()));
            this.restart();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Size chooseOptimalSize() {
        int surfaceShorter;
        int surfaceLonger;
        int surfaceWidth = this.mPreview.getWidth();
        int surfaceHeight = this.mPreview.getHeight();
        if (surfaceWidth == 0 || surfaceHeight == 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
            }
            finally {
                surfaceWidth = this.mPreview.getWidth();
                surfaceHeight = this.mPreview.getHeight();
            }
        }
        if (surfaceWidth == 0 || surfaceHeight == 0) {
            surfaceWidth = 1080;
            surfaceHeight = 1920;
        }
        if (surfaceWidth < surfaceHeight) {
            surfaceLonger = surfaceHeight;
            surfaceShorter = surfaceWidth;
        } else {
            surfaceLonger = surfaceWidth;
            surfaceShorter = surfaceHeight;
        }
        SortedSet<Size> candidates = this.mPreviewSizes.sizes(this.mAspectRatio);
        float minRation = Float.MAX_VALUE;
        Size suitSize = null;
        for (Size size : candidates) {
            float currentRation = Math.abs(1.0f - (float)surfaceLonger / (float)size.getWidth() * (float)surfaceShorter / (float)size.getHeight());
            if (!(currentRation < minRation)) continue;
            minRation = currentRation;
            suitSize = size;
        }
        return suitSize;
    }

    void updateAutoFocus() {
        if (this.mAutoFocus) {
            int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            if (modes == null || modes.length == 0 || modes.length == 1 && modes[0] == 0) {
                this.mAutoFocus = false;
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            }
        } else {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
        }
    }

    void updateFlash() {
        switch (this.mFlash) {
            case 0: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 1: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 2: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                break;
            }
            case 3: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 4: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)4);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
        }
    }

    private void lockFocus() {
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        try {
            this.mCaptureCallback.setState(1);
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
        }
        catch (Exception e) {
            this.restart();
        }
    }

    void captureStillPicture() {
        try {
            CaptureRequest.Builder captureRequestBuilder = this.mCamera.createCaptureRequest(2);
            captureRequestBuilder.addTarget(this.mImageReader.getSurface());
            captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)((Integer)this.mPreviewRequestBuilder.get(CaptureRequest.CONTROL_AF_MODE)));
            switch (this.mFlash) {
                case 0: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    break;
                }
                case 1: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                    break;
                }
                case 2: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                    break;
                }
                case 3: 
                case 4: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                }
            }
            int sensorOrientation = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            captureRequestBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)((sensorOrientation + this.mDisplayOrientation * (this.mFacing == 1 ? 1 : -1) + 360) % 360));
            this.mCaptureSession.stopRepeating();
            this.mCaptureSession.capture(captureRequestBuilder.build(), new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Camera2.this.unlockFocus();
                }
            }, null);
        }
        catch (Exception e) {
            this.restart();
        }
    }

    void unlockFocus() {
        if (!this.isCameraOpened()) {
            return;
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        try {
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            this.updateAutoFocus();
            this.updateFlash();
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            this.mCaptureCallback.setState(0);
        }
        catch (Exception e) {
            this.restart();
        }
    }

    private void restart() {
        Log.d((String)TAG, (String)"restart");
        this.stop();
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)("restart Exception " + e.getMessage()));
        }
        this.start();
    }

    @Override
    public void rectMeteringWithFocus(RectF rectF) {
        this.rectF = rectF;
        if (this.mCamera == null || this.mCameraCharacteristics == null) {
            return;
        }
        Integer maxNum = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        if (maxNum == null || maxNum <= 0) {
            return;
        }
        Rect dateRect = (Rect)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        this.rectMeteringWithFocus(dateRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rectMeteringWithFocus(Rect dateRect) {
        Class<Camera2> clazz = Camera2.class;
        synchronized (Camera2.class) {
            if (this.mCamera == null || this.mCameraCharacteristics == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Integer maxNum = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
            if (maxNum == null || maxNum <= 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.rectF == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (dateRect == null) {
                dateRect = new Rect(0, 0, 1, 1);
            }
            int dataWidth = dateRect.width() - 1;
            int dataHeight = dateRect.height() - 1;
            RectF cropRect = ScanHelper.copyRect(this.rectF);
            cropRect.left += (cropRect.right - cropRect.left) / 4.0f;
            cropRect.right -= (cropRect.right - cropRect.left) / 4.0f;
            cropRect.top += (cropRect.bottom - cropRect.top) / 4.0f;
            cropRect.bottom -= (cropRect.bottom - cropRect.top) / 4.0f;
            int left = (int)(cropRect.top * (float)dataWidth) + dateRect.left;
            int top = (int)((1.0f - cropRect.right) * (float)dataHeight) + dateRect.top;
            int right = (int)(cropRect.bottom * (float)dataWidth) + dateRect.left;
            int bottom = (int)((1.0f - cropRect.left) * (float)dataHeight) + dateRect.top;
            Rect realRect = new Rect(left, top, right, bottom);
            MeteringRectangle meteringRectangle = new MeteringRectangle(realRect, 1000);
            MeteringRectangle[] meteringRectangles = new MeteringRectangle[]{meteringRectangle};
            try {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_REGIONS, (Object)meteringRectangles);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)meteringRectangles);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)meteringRectangles);
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void releaseCallback() {
        super.releaseCallback();
        this.mCameraDeviceCallback = null;
        this.mSessionCallback = null;
        this.mCameraManager = null;
    }

    static {
        INTERNAL_FACINGS.put(0, 1);
        INTERNAL_FACINGS.put(1, 0);
    }

    private static abstract class PictureCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        static final int STATE_PREVIEW = 0;
        static final int STATE_LOCKING = 1;
        static final int STATE_LOCKED = 2;
        static final int STATE_PRECAPTURE = 3;
        static final int STATE_WAITING = 4;
        static final int STATE_CAPTURING = 5;
        private int mState;

        PictureCaptureCallback() {
        }

        void setState(int state) {
            this.mState = state;
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }

        private void process(@NonNull CaptureResult result) {
            switch (this.mState) {
                case 1: {
                    Integer af = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (af == null || af != 4 && af != 5) break;
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae == null || ae == 2) {
                        this.setState(5);
                        this.onReady();
                        break;
                    }
                    this.setState(2);
                    this.onPrecaptureRequired();
                    break;
                }
                case 3: {
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae != null && ae != 5 && ae != 4 && ae != 2) break;
                    this.setState(4);
                    break;
                }
                case 4: {
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae != null && ae == 5) break;
                    this.setState(5);
                    this.onReady();
                    break;
                }
            }
        }

        public abstract void onReady();

        public abstract void onPrecaptureRequired();
    }
}

