/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.camera;

import android.graphics.RectF;
import android.view.View;
import androidx.annotation.FloatRange;
import com.xshare.camera.camera.AspectRatio;
import com.xshare.camera.camera.PreviewImpl;
import java.util.Set;

public abstract class CameraViewImpl {
    protected Callback mCallback;
    protected PreviewImpl mPreview = null;

    CameraViewImpl(Callback callback) {
        this.mCallback = callback;
    }

    public View getView() {
        if (this.mPreview != null) {
            return this.mPreview.getView();
        }
        return null;
    }

    public void updatePreView(PreviewImpl preview) {
        this.mPreview = preview;
    }

    public abstract boolean start();

    public abstract void stop();

    public abstract boolean isCameraOpened();

    public abstract void setFacing(int var1);

    public abstract int getFacing();

    public abstract Set<AspectRatio> getSupportedAspectRatios();

    public abstract boolean setAspectRatio(AspectRatio var1);

    public abstract AspectRatio getAspectRatio();

    public abstract void setAutoFocus(boolean var1);

    public abstract boolean getAutoFocus();

    public abstract void setFlash(int var1);

    public abstract int getFlash();

    public abstract void takePicture();

    public abstract void setDisplayOrientation(int var1);

    public abstract void toZoomMax();

    public abstract void toZoomMin();

    public abstract void setZoom(@FloatRange(from=0.0, to=1.0) float var1);

    public abstract void lightOperator(boolean var1);

    public void rectMeteringWithFocus(RectF rectF) {
    }

    public void releaseCallback() {
        if (this.mCallback != null) {
            this.mCallback = null;
        }
        if (this.mPreview != null) {
            this.mPreview = null;
        }
    }

    public static interface Callback {
        public void onCameraOpened();

        public void onCameraClosed();

        public void onPreviewByte(byte[] var1);

        public void onPictureTaken(byte[] var1);
    }
}

