/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.camera;

import android.os.Handler;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import com.xshare.camera.camera.AspectRatio;
import com.xshare.camera.cameraview.CameraView;

public abstract class PreviewImpl {
    private Handler cameraHandler;
    private Callback mCallback;
    private volatile int mWidth;
    private volatile int mHeight;

    void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setCameraHandle(Handler cameraHandle) {
        this.cameraHandler = cameraHandle;
    }

    abstract Surface getSurface();

    abstract View getView();

    abstract Class getOutputClass();

    abstract void setDisplayOrientation(int var1);

    abstract boolean isReady();

    protected void dispatchSurfaceChanged() {
        if (this.cameraHandler != null) {
            this.cameraHandler.post(() -> this.mCallback.onSurfaceChanged());
        } else {
            this.mCallback.onSurfaceChanged();
        }
    }

    SurfaceHolder getSurfaceHolder() {
        return null;
    }

    Object getSurfaceTexture() {
        return null;
    }

    void setBufferSize(int width, int height) {
    }

    void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        View v = (View)this.getView().getParent();
        v.post(() -> {
            this.getView().setTranslationX(0.0f);
            this.getView().setTranslationY(0.0f);
            if (v == null) {
                return;
            }
            if (width > v.getMeasuredWidth()) {
                this.getView().setTranslationX((float)(-(width - v.getMeasuredWidth())) / 2.0f);
            }
            if (height > v.getMeasuredHeight()) {
                this.getView().setTranslationY((float)(-(height - v.getMeasuredHeight())) / 2.0f);
            }
        });
        if (this.cameraHandler != null && this.cameraHandler.getLooper().getThread().getState() == Thread.State.TIMED_WAITING) {
            this.cameraHandler.getLooper().getThread().interrupt();
        }
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    public void updateAspectRatio(AspectRatio aspectRatio) {
        this.mWidth = 0;
        this.mHeight = 0;
        if (this.getView().getParent() instanceof CameraView) {
            ((CameraView)this.getView().getParent()).setAspectRatio(aspectRatio);
        }
    }

    static interface Callback {
        public void onSurfaceChanged();
    }
}

