/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import com.xshare.camera.Config;
import com.xshare.camera.camera.PreviewImpl;
import com.xshare.trans.R;

@TargetApi(value=14)
public class TextureViewPreview
extends PreviewImpl {
    private final TextureView mTextureView;
    private int mDisplayOrientation;

    public TextureViewPreview(Context context, ViewGroup parent) {
        View view = View.inflate((Context)context, (int)R.layout.trans_texture_view, (ViewGroup)parent);
        this.mTextureView = (TextureView)view.findViewById(R.id.texture_view);
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                TextureViewPreview.this.setSize(width, height);
                TextureViewPreview.this.configureTransform();
                TextureViewPreview.this.dispatchSurfaceChanged();
                Log.d((String)"Camera2", (String)"onSurfaceTextureAvailable");
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                TextureViewPreview.this.setSize(width, height);
                TextureViewPreview.this.configureTransform();
                TextureViewPreview.this.dispatchSurfaceChanged();
                Log.d((String)"Camera2", (String)"onSurfaceTextureSizeChanged");
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                TextureViewPreview.this.setSize(0, 0);
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
    }

    @Override
    @TargetApi(value=15)
    void setBufferSize(int widthData, int heightData) {
        if (Config.scanRect != null) {
            Config.scanRect.setDataX(widthData);
            Config.scanRect.setDataY(heightData);
        }
        if (this.getSurfaceTexture() != null) {
            this.getSurfaceTexture().setDefaultBufferSize(widthData, heightData);
        }
    }

    @Override
    Surface getSurface() {
        return new Surface(this.mTextureView.getSurfaceTexture());
    }

    SurfaceTexture getSurfaceTexture() {
        return this.mTextureView.getSurfaceTexture();
    }

    @Override
    View getView() {
        return this.mTextureView;
    }

    @Override
    Class getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
        this.configureTransform();
    }

    @Override
    boolean isReady() {
        boolean isReady = this.mTextureView.getSurfaceTexture() != null;
        Log.d((String)"Camera2", (String)("TextureViewPreview isReady =  " + isReady));
        return isReady;
    }

    void configureTransform() {
        Matrix matrix = new Matrix();
        if (this.getView().getContext().getResources().getConfiguration().orientation == 2 && this.mDisplayOrientation == 0) {
            this.mDisplayOrientation = Config.displayOrientation;
        }
        if (this.mDisplayOrientation % 180 == 90) {
            float[] fArray;
            int width = this.getWidth();
            int height = this.getHeight();
            float[] fArray2 = new float[]{0.0f, 0.0f, width, 0.0f, 0.0f, height, width, height};
            if (this.mDisplayOrientation == 90) {
                float[] fArray3 = new float[8];
                fArray3[0] = 0.0f;
                fArray3[1] = height;
                fArray3[2] = 0.0f;
                fArray3[3] = 0.0f;
                fArray3[4] = width;
                fArray3[5] = height;
                fArray3[6] = width;
                fArray = fArray3;
                fArray3[7] = 0.0f;
            } else {
                float[] fArray4 = new float[8];
                fArray4[0] = width;
                fArray4[1] = 0.0f;
                fArray4[2] = width;
                fArray4[3] = height;
                fArray4[4] = 0.0f;
                fArray4[5] = 0.0f;
                fArray4[6] = 0.0f;
                fArray = fArray4;
                fArray4[7] = height;
            }
            matrix.setPolyToPoly(fArray2, 0, fArray, 0, 4);
        } else if (this.mDisplayOrientation == 180) {
            matrix.postRotate(180.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        }
        this.mTextureView.setTransform(matrix);
    }
}

