/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.cameraview;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import com.xshare.camera.Config;
import com.xshare.camera.Utils;
import com.xshare.camera.camera.AspectRatio;
import com.xshare.camera.cameraview.CameraView;
import com.xshare.camera.view.LifeOwner;

public abstract class BaseCameraView
extends CameraView
implements LifeOwner {
    public static final String TAG = "Camera2";
    protected boolean isShoudCreateOpen = true;
    protected boolean isProscribeCamera = false;
    private Long cameraStartTime = 0L;
    private Handler cameraHandler;

    public BaseCameraView(Context context) {
        this(context, null);
    }

    public BaseCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.inti();
    }

    public void inti() {
        Config.initConfig();
        this.setAutoFocus(true);
        this.setAdjustViewBounds(false);
        HandlerThread handlerThread = new HandlerThread("CameraProcessThread", 0);
        handlerThread.start();
        this.cameraHandler = new Handler(handlerThread.getLooper());
        this.provideCameraHandler(this.cameraHandler);
        this.addCallback(new CameraView.Callback(){

            @Override
            public void onCameraOpened(CameraView cameraView) {
                Log.d((String)BaseCameraView.TAG, (String)"inti onCameraOpened");
                BaseCameraView.this.mainHand.post(() -> BaseCameraView.this.onCameraOpenBack(cameraView));
            }

            @Override
            public void onCameraClosed(CameraView cameraView) {
                Log.d((String)BaseCameraView.TAG, (String)"inti onCameraClosed");
                BaseCameraView.this.mainHand.post(() -> BaseCameraView.this.onCameraCloseBack(cameraView));
            }

            @Override
            public void onPictureTaken(CameraView cameraView, byte[] data) {
                BaseCameraView.this.mainHand.post(() -> BaseCameraView.this.onPictureTakeBack(cameraView, data));
            }

            @Override
            public void onPreviewByte(CameraView cameraView, byte[] data) {
                if (data != null) {
                    BaseCameraView.this.onPreviewByteBack(cameraView, data);
                }
            }
        });
    }

    public abstract void onCameraOpenBack(CameraView var1);

    public abstract void onCameraCloseBack(CameraView var1);

    public void onPictureTakeBack(CameraView camera, byte[] data) {
    }

    public void onPreviewByteBack(CameraView camera, byte[] data) {
    }

    public void onCreate(@NonNull LifecycleOwner owner) {
        this.onCameraCreate();
        Log.d((String)TAG, (String)(" onCreate isShoudCreateOpen = " + this.isShoudCreateOpen));
    }

    public void onPause(@NonNull LifecycleOwner owner) {
        this.onCameraPause();
        Log.d((String)TAG, (String)(" onPause isShoudCreateOpen = " + this.isShoudCreateOpen));
    }

    public void onResume(@NonNull LifecycleOwner owner) {
        this.onCameraResume();
        Log.d((String)TAG, (String)(" onResume isShoudCreateOpen = " + this.isShoudCreateOpen));
    }

    public void onStop(@NonNull LifecycleOwner owner) {
    }

    public void onDestroy(@NonNull LifecycleOwner owner) {
        this.cameraHandler.getLooper().quit();
    }

    public void onCameraCreate() {
        if (!this.isShoudCreateOpen) {
            Log.d((String)TAG, (String)"onCameraCreate \u76f8\u673a\u5df2\u521b\u5efa isShoudCreateOpen = true \u8fd4\u56de");
            return;
        }
        if (Utils.checkPermissionCamera(this.getContext()).booleanValue()) {
            Log.d((String)TAG, (String)("onCameraCreate \u76f8\u673a\u5f00\u59cb\u521b\u5efa isShoudCreateOpen = " + this.isShoudCreateOpen));
            this.openCameraBefore();
            this.openCamera(0L);
        } else {
            Utils.requstPermission(this.getContext());
        }
    }

    public void onCameraResume() {
        if (this.isShoudCreateOpen) {
            Log.d((String)TAG, (String)"onCameraResume \u5916\u90e8\u4f7f\u7528\u8be5\u65b9\u6cd5\u542f\u52a8\u76f8\u673a \u9632\u6b62\u91cd\u590d\u6253\u5f00\uff0c\u76f4\u63a5\u8fd4\u56de isShoudCreateOpen = true");
            return;
        }
        if (Utils.checkPermissionCamera(this.getContext()).booleanValue() && !this.isCameraOpened()) {
            Log.d((String)TAG, (String)("onCameraResume \u5916\u90e8\u4f7f\u7528\u8be5\u65b9\u6cd5\u542f\u52a8\u76f8\u673a\uff0c\u5df2\u83b7\u5f97\u7126\u70b9 isShoudCreateOpen = " + this.isShoudCreateOpen));
            this.openCameraBefore();
            this.openCamera(this.cameraStartTime != 0L ? this.cameraStartTime : 500L);
        }
    }

    public void onCameraPause() {
        Log.d((String)TAG, (String)"onCameraPause");
        this.closeCameraBefore();
        this.closeCamera();
        this.isShoudCreateOpen = false;
    }

    @Override
    public void setAspectRatio(@NonNull AspectRatio ratio) {
        super.setAspectRatio(ratio);
        Log.d((String)TAG, (String)("setAspectRatio ratio = " + ratio.toString()));
    }

    public void openCamera(Long delayMillis) {
        Log.d((String)TAG, (String)("openCamera delayMillis = " + delayMillis));
        this.cameraHandler.removeCallbacksAndMessages(null);
        this.cameraHandler.postDelayed(() -> {
            if (!this.isProscribeCamera) {
                long var0 = System.currentTimeMillis();
                this.start();
                this.cameraStartTime = System.currentTimeMillis() - var0;
            }
        }, delayMillis.longValue());
    }

    public void closeCamera() {
        Log.d((String)TAG, (String)"closeCamera \u5173\u95ed\u76f8\u673a");
        this.cameraHandler.removeCallbacksAndMessages(null);
        this.cameraHandler.postDelayed(this::stop, this.cameraStartTime.longValue());
    }

    public void proscribeCamera() {
        Log.d((String)TAG, (String)"proscribeCamera \u7981\u6b62\u76f8\u673a\u542f\u7528");
        this.isProscribeCamera = true;
        this.onCameraPause();
    }

    public void unProscibeCamera() {
        Log.d((String)TAG, (String)"unProscibeCamera \u5141\u8bb8\u5e76\u542f\u7528\u76f8\u673a");
        this.isProscribeCamera = false;
        this.onCameraResume();
    }

    public void setZoom(Float percent) {
        Log.d((String)TAG, (String)("setZoom \u6570\u5b57\u53d8\u7126 percent = " + percent));
        if (percent.floatValue() >= 1.0f) {
            this.mImpl.toZoomMax();
            Config.currentZoom = 1.0f;
        } else if (percent.floatValue() <= 0.0f) {
            this.mImpl.toZoomMin();
            Config.currentZoom = 0.0f;
        } else {
            this.mImpl.setZoom(percent.floatValue());
            Config.currentZoom = percent.floatValue();
        }
    }

    protected void lightOperator(Boolean isOpen) {
        Log.d((String)TAG, (String)("lightOperator \u6253\u5f00/\u5173\u95ed \u95ea\u5149\u706f isOpen = " + isOpen));
        if (this.mImpl != null) {
            this.mImpl.lightOperator(isOpen);
        }
    }
}

