/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.cameraview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.xshare.camera.Config;
import com.xshare.camera.camera.AspectRatio;
import com.xshare.camera.camera.Camera1;
import com.xshare.camera.camera.Camera2;
import com.xshare.camera.camera.CameraViewImpl;
import com.xshare.camera.camera.Constants;
import com.xshare.camera.camera.PreviewImpl;
import com.xshare.camera.camera.TextureViewPreview;
import com.xshare.camera.cameraview.DisplayOrientationDetector;
import com.xshare.trans.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;

public class CameraView
extends FrameLayout {
    public static final int FACING_BACK = 0;
    public static final int FACING_FRONT = 1;
    private PreviewImpl preview;
    private Handler cameraHandler;
    public static final int FLASH_OFF = 0;
    public static final int FLASH_ON = 1;
    public static final int FLASH_TORCH = 2;
    public static final int FLASH_AUTO = 3;
    public static final int FLASH_RED_EYE = 4;
    protected Handler mainHand = new Handler(Looper.getMainLooper());
    protected CameraViewImpl mImpl;
    private CallbackBridge mCallbacks;
    private boolean mAdjustViewBounds;
    protected final DisplayOrientationDetector mDisplayOrientationDetector;

    public CameraView(Context context) {
        this(context, null);
    }

    public CameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            this.mCallbacks = null;
            this.mDisplayOrientationDetector = null;
            return;
        }
        this.setBackgroundColor(-16777216);
        this.mCallbacks = new CallbackBridge();
        this.mImpl = Build.VERSION.SDK_INT < 21 ? new Camera1(this.mCallbacks) : new Camera2(this.mCallbacks, context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraView, defStyleAttr, R.style.Widget_CameraView);
        this.mAdjustViewBounds = a.getBoolean(R.styleable.CameraView_android_adjustViewBounds, false);
        this.setFacing(a.getInt(R.styleable.CameraView_facing, 0));
        this.setAspectRatio(this.provideAspectRatio());
        this.setAutoFocus(a.getBoolean(R.styleable.CameraView_autoFocus, true));
        this.setFlash(a.getInt(R.styleable.CameraView_flash, 3));
        a.recycle();
        this.mDisplayOrientationDetector = new DisplayOrientationDetector(context){

            @Override
            public void onDisplayOrientationChanged(int displayOrientation) {
                CameraView.this.mImpl.setDisplayOrientation(displayOrientation);
            }
        };
    }

    @NonNull
    private PreviewImpl createPreviewImpl(Context context) {
        this.preview = new TextureViewPreview(context, (ViewGroup)this);
        this.preview.setCameraHandle(this.cameraHandler);
        return this.preview;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.enable(ViewCompat.getDisplay((View)this));
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.disable();
        }
        this.mCallbacks.removeAll();
        this.mCallbacks = null;
        this.mImpl.releaseCallback();
        this.mImpl = null;
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isInEditMode()) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mImpl.getView() == null) {
            return;
        }
        AspectRatio ratio = this.getAspectRatio();
        if (ratio == null) {
            return;
        }
        if (this.getContext().getResources().getConfiguration().orientation == 1) {
            Config.displayOrientation = 0;
            ratio = ratio.inverse();
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (height < width * ratio.getY() / ratio.getX()) {
            int realHeight = (int)((float)(width * ratio.getY()) / (float)ratio.getX());
            if (this.mImpl != null && this.mImpl.getView() != null) {
                this.mImpl.getView().measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)realHeight, (int)0x40000000));
                Config.scanRect.setExtraX(0);
                Config.scanRect.setExtraY(realHeight - height);
            }
        } else {
            int realWidth = (int)((float)(height * ratio.getX()) / (float)ratio.getY());
            if (this.mImpl != null && this.mImpl.getView() != null) {
                this.mImpl.getView().measure(View.MeasureSpec.makeMeasureSpec((int)realWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
                Config.scanRect.setExtraX(realWidth - width);
                Config.scanRect.setExtraY(0);
            }
        }
        Config.scanRect.setPreX(this.getMeasuredWidth());
        Config.scanRect.setPreY(this.getMeasuredHeight());
    }

    protected RectF preRect2RealDataRect(View view) {
        RectF r = new RectF();
        int oriHeight = this.getMeasuredHeight();
        int oriWidth = this.getMeasuredWidth();
        AspectRatio ratio = this.getAspectRatio();
        if (ratio == null) {
            return r;
        }
        if (this.getContext().getResources().getConfiguration().orientation == 1) {
            Config.displayOrientation = 0;
            ratio = ratio.inverse();
        } else if (this.mDisplayOrientationDetector.getLastKnownDisplayOrientation() != 0) {
            Config.displayOrientation = this.mDisplayOrientationDetector.getLastKnownDisplayOrientation();
        }
        if (oriHeight < oriWidth * ratio.getY() / ratio.getX()) {
            int realHeight = (int)((float)(oriWidth * ratio.getY()) / (float)ratio.getX());
            float expectRatio = (float)(realHeight - oriHeight) / 2.0f / (float)realHeight;
            float[] edgeRatio = this.findEdgeRatio(view, oriWidth, realHeight);
            r.left = edgeRatio[0];
            r.right = edgeRatio[2];
            r.top = expectRatio + edgeRatio[1];
            r.bottom = expectRatio + edgeRatio[3];
        } else {
            int realWidth = (int)((float)(oriHeight * ratio.getX()) / (float)ratio.getY());
            float expectRatio = (float)(realWidth - oriWidth) / 2.0f / (float)realWidth;
            float[] edgeRatio = this.findEdgeRatio(view, realWidth, oriHeight);
            r.left = expectRatio + edgeRatio[0];
            r.right = expectRatio + edgeRatio[2];
            r.top = edgeRatio[1];
            r.bottom = edgeRatio[3];
        }
        return r;
    }

    protected void defineScanParseRect(View view) {
        if (view == null || this.mImpl == null) {
            return;
        }
        Config.scanRect.setRect(this.preRect2RealDataRect(view));
        Config.scanRect.setScanR(null);
        Config.scanRect.setScanRR(null);
        this.mImpl.rectMeteringWithFocus(Config.scanRect.getRect());
    }

    protected void useRectMeteringWithFocus(View view) {
        this.mImpl.rectMeteringWithFocus(this.preRect2RealDataRect(view));
    }

    private float[] findEdgeRatio(View view, int realWidht, int realHeight) {
        int[] parseRect;
        int[] parseRect_screen = new int[2];
        view.getLocationOnScreen(parseRect_screen);
        parseRect = new int[]{parseRect_screen[0], parseRect_screen[1], parseRect[0] + view.getMeasuredWidth(), parseRect[1] + view.getMeasuredHeight()};
        int[] surfaceRect_screen = new int[2];
        this.getLocationOnScreen(surfaceRect_screen);
        float[] edgeRatio = new float[]{(float)(parseRect[0] - surfaceRect_screen[0]) / (float)realWidht, (float)(parseRect[1] - surfaceRect_screen[1]) / (float)realHeight, (float)(parseRect[2] - surfaceRect_screen[0]) / (float)realWidht, (float)(parseRect[3] - surfaceRect_screen[1]) / (float)realHeight};
        for (int i = 0; i < 4; ++i) {
            if (edgeRatio[i] < 0.0f) {
                edgeRatio[i] = 0.0f;
            }
            if (!(edgeRatio[i] > 1.0f)) continue;
            edgeRatio[i] = 1.0f;
        }
        return edgeRatio;
    }

    protected void provideCameraHandler(Handler handler) {
        this.cameraHandler = handler;
        if (this.preview != null) {
            this.preview.setCameraHandle(this.cameraHandler);
        }
    }

    protected PreviewImpl getPreviewImpl() {
        return this.preview;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        if (null == this.mImpl) {
            return super.onSaveInstanceState();
        }
        SavedState state = new SavedState(super.onSaveInstanceState());
        state.facing = this.getFacing();
        state.ratio = this.getAspectRatio();
        state.autoFocus = this.getAutoFocus();
        state.flash = this.getFlash();
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setFacing(ss.facing);
        this.setAspectRatio(ss.ratio);
        this.setAutoFocus(ss.autoFocus);
        this.setFlash(ss.flash);
    }

    private void initPreView() {
        this.mImpl.updatePreView(this.createPreviewImpl(this.getContext()));
    }

    public void openCameraBefore() {
        this.removeAllViews();
        this.initPreView();
    }

    public void closeCameraBefore() {
    }

    protected void start() {
        if (!this.isCameraOpened() && !this.mImpl.start()) {
            Parcelable state = this.onSaveInstanceState();
            this.mImpl = new Camera1(this.mCallbacks);
            this.mImpl.updatePreView(this.preview);
            this.onRestoreInstanceState(state);
            this.mImpl.start();
        }
    }

    protected void stop() {
        if (this.isCameraOpened()) {
            this.mImpl.stop();
        }
    }

    public boolean isCameraOpened() {
        return this.mImpl.isCameraOpened();
    }

    public void addCallback(@NonNull Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeCallback(@NonNull Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (this.mAdjustViewBounds != adjustViewBounds) {
            this.mAdjustViewBounds = adjustViewBounds;
            this.requestLayout();
        }
    }

    public boolean getAdjustViewBounds() {
        return this.mAdjustViewBounds;
    }

    public void setFacing(int facing) {
        this.mImpl.setFacing(facing);
    }

    public int getFacing() {
        if (null == this.mImpl) {
            return 0;
        }
        return this.mImpl.getFacing();
    }

    protected AspectRatio provideAspectRatio() {
        return Constants.DEFAULT_ASPECT_RATIO;
    }

    public Set<AspectRatio> getSupportedAspectRatios() {
        return this.mImpl.getSupportedAspectRatios();
    }

    public void setAspectRatio(@NonNull AspectRatio ratio) {
        if (this.mImpl.setAspectRatio(ratio)) {
            this.mainHand.post(() -> ((CameraView)this).requestLayout());
        }
    }

    @Nullable
    public AspectRatio getAspectRatio() {
        if (this.mImpl != null) {
            return this.mImpl.getAspectRatio();
        }
        return null;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.mImpl.setAutoFocus(autoFocus);
    }

    public boolean getAutoFocus() {
        if (null == this.mImpl) {
            return false;
        }
        return this.mImpl.getAutoFocus();
    }

    public void setFlash(@Flash int flash) {
        this.mImpl.setFlash(flash);
    }

    @Flash
    public int getFlash() {
        return this.mImpl.getFlash();
    }

    public void takePicture() {
        if (this.isCameraOpened()) {
            this.mImpl.takePicture();
        }
    }

    public static abstract class Callback {
        public void onCameraOpened(CameraView cameraView) {
        }

        public void onCameraClosed(CameraView cameraView) {
        }

        public void onPictureTaken(CameraView cameraView, byte[] data) {
        }

        public void onPreviewByte(CameraView cameraView, byte[] data) {
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        int facing;
        AspectRatio ratio;
        boolean autoFocus;
        @Flash
        int flash;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return this.createFromParcel(in, null);
            }

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source, ClassLoader loader) {
            super(source);
            this.facing = source.readInt();
            this.ratio = (AspectRatio)source.readParcelable(loader);
            this.autoFocus = source.readByte() != 0;
            this.flash = source.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.facing);
            out.writeParcelable((Parcelable)this.ratio, 0);
            out.writeByte((byte)(this.autoFocus ? 1 : 0));
            out.writeInt(this.flash);
        }
    }

    private class CallbackBridge
    implements CameraViewImpl.Callback {
        private final ArrayList<Callback> mCallbacks = new ArrayList();
        private boolean mRequestLayoutOnOpen;

        CallbackBridge() {
        }

        public void add(Callback callback) {
            this.mCallbacks.add(callback);
        }

        public void remove(Callback callback) {
            this.mCallbacks.remove(callback);
        }

        public void removeAll() {
            this.mCallbacks.clear();
        }

        @Override
        public void onCameraOpened() {
            if (this.mRequestLayoutOnOpen) {
                this.mRequestLayoutOnOpen = false;
                CameraView.this.requestLayout();
            }
            for (Callback callback : this.mCallbacks) {
                callback.onCameraOpened(CameraView.this);
            }
        }

        @Override
        public void onCameraClosed() {
            for (Callback callback : this.mCallbacks) {
                callback.onCameraClosed(CameraView.this);
            }
        }

        @Override
        public void onPreviewByte(byte[] data) {
            for (Callback callback : this.mCallbacks) {
                callback.onPreviewByte(CameraView.this, data);
            }
        }

        @Override
        public void onPictureTaken(byte[] data) {
            for (Callback callback : this.mCallbacks) {
                callback.onPictureTaken(CameraView.this, data);
            }
        }

        public void reserveRequestLayoutOnOpen() {
            this.mRequestLayoutOnOpen = true;
        }
    }

    public static @interface Flash {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Facing {
    }
}

