/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.grayscale;

import android.graphics.Rect;
import com.xshare.camera.grayscale.Dispatch;

class InterruptGrayScale
implements Dispatch {
    private int stepX = 2;
    private int stepY = 2;

    InterruptGrayScale() {
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height) {
        int offset = (int)(Math.random() * 3.0) + 1;
        Rect rect = new Rect(0, 0, width, height);
        for (int i = 0; i < offset; ++i) {
            this.openOp(data, width, rect, i);
            this.closeOp(data, width, rect, i);
        }
        return data;
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height, Rect rect) {
        byte[] newByte = (byte[])data.clone();
        int offset = (int)(Math.random() * 5.0) + 1;
        for (int i = 0; i < offset; ++i) {
            this.openOp(newByte, width, rect, i);
            this.closeOp(newByte, width, rect, i);
        }
        return newByte;
    }

    private void openOp(byte[] newByte, int width, Rect rect, int offset) {
        int step_h = rect.top + offset;
        while (step_h + this.stepY < rect.bottom) {
            int step_w = rect.left + offset;
            while (step_w + this.stepX < rect.right) {
                int x_;
                int y_;
                int count = 0;
                int avage = 0;
                int min = Integer.MAX_VALUE;
                for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                    for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                        if ((newByte[y_ * width + x_] & 0xFF) < 150) {
                            ++count;
                        }
                        avage += newByte[y_ * width + x_] & 0xFF;
                        if ((newByte[y_ * width + x_] & 0xFF) >= min) continue;
                        min = newByte[y_ * width + x_] & 0xFF;
                    }
                }
                if (count != 0) {
                    avage /= this.stepY * this.stepX;
                    for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                        for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                            newByte[y_ * width + x_] = (byte)(min / 5 * 4);
                        }
                    }
                }
                step_w += this.stepX;
            }
            step_h += this.stepY;
        }
    }

    private void closeOp(byte[] newByte, int width, Rect rect, int offset) {
        int step_h = rect.top + offset;
        while (step_h + this.stepY < rect.bottom) {
            int step_w = rect.left + offset;
            while (step_w + this.stepX < rect.right) {
                int x_;
                int y_;
                int count = 0;
                int max = 0;
                for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                    for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                        if ((newByte[y_ * width + x_] & 0xFF) < 150) {
                            ++count;
                        }
                        if ((newByte[y_ * width + x_] & 0xFF) <= max) continue;
                        max = newByte[y_ * width + x_] & 0xFF;
                    }
                }
                if (count <= this.stepX * this.stepY / 2) {
                    for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                        for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                            newByte[y_ * width + x_] = (byte)max;
                        }
                    }
                }
                step_w += this.stepX;
            }
            step_h += this.stepY;
        }
    }
}

