/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.grayscale;

import android.graphics.Rect;
import com.xshare.camera.grayscale.Dispatch;
import java.util.HashSet;
import java.util.Iterator;

class InterruptGrayScale_
implements Dispatch {
    private int stepX = 10;
    private int stepY = 10;
    private static final int BLOCK_SIZE_POWER = 2;
    private static final int BLOCK_SIZE = 4;
    private static final int BLOCK_SIZE_MASK = 3;
    private static final int MINIMUM_DIMENSION = 20;
    private static final int MIN_DYNAMIC_RANGE = 24;

    InterruptGrayScale_() {
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height) {
        byte[] newByte = (byte[])data.clone();
        int step_h = 0;
        while (step_h + this.stepY < height) {
            int step_w = 0;
            while (step_w + this.stepX < width) {
                int x_;
                int y_;
                int count = 0;
                int avage = 0;
                for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                    for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                        if ((newByte[y_ * width + x_] & 0xFF) < 130) {
                            ++count;
                        }
                        avage += newByte[y_ * width + x_] & 0xFF;
                    }
                }
                if (count != 0) {
                    for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                        for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                            newByte[y_ * width + x_] = (newByte[y_ * width + x_] & 0xFF) > avage ? (byte)(avage & 0xFF) : (byte)(newByte[y_ * width + x_] & 0xFF);
                        }
                    }
                }
                step_w += this.stepX;
            }
            step_h += this.stepY;
        }
        return newByte;
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height, Rect rect) {
        int index;
        int start_w;
        int start_h;
        byte[] newByte = (byte[])data.clone();
        byte[] binarizationByte = new byte[rect.width() * rect.height()];
        int linkIndex = 0;
        for (start_h = rect.top; start_h < rect.bottom; ++start_h) {
            for (start_w = rect.left; start_w < rect.right; ++start_w) {
                index = start_h * width + start_w;
                binarizationByte[linkIndex++] = newByte[index];
            }
        }
        linkIndex = 0;
        this.toBinarization(binarizationByte, rect.width(), rect.height());
        for (int i = 0; i < 5; ++i) {
            this.openOp(binarizationByte, rect.width(), rect.height(), 0);
            this.closeOp(binarizationByte, rect.width(), rect.height(), 0);
        }
        for (start_h = rect.top; start_h < rect.bottom; ++start_h) {
            for (start_w = rect.left; start_w < rect.right; ++start_w) {
                index = start_h * width + start_w;
                newByte[index] = binarizationByte[linkIndex++];
            }
        }
        return newByte;
    }

    private void openOp(byte[] newByte, int width, int height, int offset) {
        HashSet<Integer> set = new HashSet<Integer>();
        int step_h = offset;
        while (step_h + this.stepY < height) {
            int step_w = offset;
            while (step_w + this.stepX < width) {
                int x_;
                int y_;
                int count = 0;
                for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                    for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                        if (y_ * width + x_ >= width * height) {
                            return;
                        }
                        if ((newByte[y_ * width + x_] & 0xFF) != 0) continue;
                        ++count;
                    }
                }
                if (count != 0) {
                    for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                        for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                            set.add(y_ * width + x_);
                        }
                    }
                }
                step_w += this.stepX;
            }
            step_h += this.stepY;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            newByte[index] = 0;
        }
    }

    private void closeOp(byte[] newByte, int width, int height, int offset) {
        HashSet<Integer> set = new HashSet<Integer>();
        int step_h = offset;
        while (step_h + this.stepY < height) {
            int step_w = offset;
            while (step_w + this.stepX < width) {
                int x_;
                int y_;
                int count = 0;
                for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                    for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                        if (y_ * width + x_ >= width * height) {
                            return;
                        }
                        if ((newByte[y_ * width + x_] & 0xFF) != 255) continue;
                        ++count;
                    }
                }
                if (count != 0) {
                    for (y_ = step_h; y_ < step_h + this.stepY; ++y_) {
                        for (x_ = step_w; x_ < step_w + this.stepX; ++x_) {
                            set.add(y_ * width + x_);
                        }
                    }
                }
                step_w += this.stepX;
            }
            step_h += this.stepY;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            newByte[index] = -1;
        }
    }

    private void toBinarization(byte[] luminances, int width, int height) {
        int subWidth = width >> 2;
        if ((width & 3) != 0) {
            ++subWidth;
        }
        int subHeight = height >> 2;
        if ((height & 3) != 0) {
            ++subHeight;
        }
        int[][] blackPoints = this.calculateBlackPoints(luminances, subWidth, subHeight, width, height);
        this.calculateThresholdForBlock(luminances, subWidth, subHeight, width, height, blackPoints);
    }

    private int[][] calculateBlackPoints(byte[] luminances, int subWidth, int subHeight, int width, int height) {
        int maxYOffset = height - 4;
        int maxXOffset = width - 4;
        int[][] blackPoints = new int[subHeight][subWidth];
        for (int y = 0; y < subHeight; ++y) {
            int yoffset = y << 2;
            if (yoffset > maxYOffset) {
                yoffset = maxYOffset;
            }
            for (int x = 0; x < subWidth; ++x) {
                int xoffset = x << 2;
                if (xoffset > maxXOffset) {
                    xoffset = maxXOffset;
                }
                int sum = 0;
                int min = 255;
                int max = 0;
                int yy = 0;
                int offset = yoffset * width + xoffset;
                while (yy < 4) {
                    int xx;
                    for (xx = 0; xx < 4; ++xx) {
                        int pixel = luminances[offset + xx] & 0xFF;
                        sum += pixel;
                        if (pixel < min) {
                            min = pixel;
                        }
                        if (pixel <= max) continue;
                        max = pixel;
                    }
                    if (max - min > 24) {
                        ++yy;
                        offset += width;
                        while (yy < 4) {
                            for (xx = 0; xx < 4; ++xx) {
                                sum += luminances[offset + xx] & 0xFF;
                            }
                            ++yy;
                            offset += width;
                        }
                    }
                    ++yy;
                    offset += width;
                }
                int average = sum >> 4;
                if (max - min <= 24) {
                    int averageNeighborBlackPoint;
                    average = min / 2;
                    if (y > 0 && x > 0 && min < (averageNeighborBlackPoint = (blackPoints[y - 1][x] + 2 * blackPoints[y][x - 1] + blackPoints[y - 1][x - 1]) / 4)) {
                        average = averageNeighborBlackPoint;
                    }
                }
                blackPoints[y][x] = average;
            }
        }
        return blackPoints;
    }

    private void calculateThresholdForBlock(byte[] luminances, int subWidth, int subHeight, int width, int height, int[][] blackPoints) {
        int maxYOffset = height - 4;
        int maxXOffset = width - 4;
        for (int y = 0; y < subHeight; ++y) {
            int yoffset = y << 2;
            if (yoffset > maxYOffset) {
                yoffset = maxYOffset;
            }
            int top = this.cap(y, subHeight - 3);
            for (int x = 0; x < subWidth; ++x) {
                int xoffset = x << 2;
                if (xoffset > maxXOffset) {
                    xoffset = maxXOffset;
                }
                int left = this.cap(x, subWidth - 3);
                int sum = 0;
                for (int z = -2; z <= 2; ++z) {
                    int[] blackRow = blackPoints[top + z];
                    sum += blackRow[left - 2] + blackRow[left - 1] + blackRow[left] + blackRow[left + 1] + blackRow[left + 2];
                }
                int average = sum / 25;
                this.thresholdBlock(luminances, xoffset, yoffset, average, width);
            }
        }
    }

    private int cap(int value, int max) {
        return value < 2 ? 2 : Math.min(value, max);
    }

    private void thresholdBlock(byte[] luminances, int xoffset, int yoffset, int threshold, int stride) {
        int y = 0;
        int offset = yoffset * stride + xoffset;
        while (y < 4) {
            for (int x = 0; x < 4; ++x) {
                luminances[offset + x] = (luminances[offset + x] & 0xFF) <= threshold ? 0 : -1;
            }
            ++y;
            offset += stride;
        }
    }
}

