/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.grayscale;

import android.graphics.Rect;
import com.xshare.camera.grayscale.Dispatch;
import com.xshare.camera.grayscale.TranslationScale;

class OverlyGrayScale
implements Dispatch {
    TranslationScale translationScale = new TranslationScale(10, 10);

    OverlyGrayScale() {
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height) {
        return data;
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height, Rect rect) {
        byte[] newByte = (byte[])data.clone();
        byte[] tranByte = this.translationScale.dispatch(data, width, height, rect);
        int stepX = 2;
        int stepY = 2;
        for (int start_h = rect.top; start_h < rect.bottom; start_h += stepY) {
            for (int start_w = rect.left; start_w < rect.right; start_w += stepX) {
                int i;
                int oriAvage = 0;
                int tranAvage = 0;
                int min = Integer.MAX_VALUE;
                for (i = start_h; i < start_h + stepY; ++i) {
                    for (int j = start_w; j < start_w + stepX; ++j) {
                        oriAvage += newByte[i * width + j] & 0xFF;
                        tranAvage += tranByte[i * width + j] & 0xFF;
                        if ((tranByte[i * width + j] & 0xFF) >= min) continue;
                        min = tranByte[i * width + j] & 0xFF;
                    }
                }
                if (oriAvage <= tranAvage) continue;
                for (i = start_h; i < start_h + stepY; ++i) {
                    System.arraycopy(tranByte, i * width + start_w, newByte, i * width + start_w, start_w + stepX - start_w);
                }
            }
        }
        return newByte;
    }
}

