/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.grayscale;

import android.graphics.Rect;
import com.xshare.camera.grayscale.Dispatch;
import com.xshare.camera.grayscale.GrayScaleDispatch;

class ReductionAreaScale
implements Dispatch {
    GrayScaleDispatch grayScaleDispatch;

    ReductionAreaScale(GrayScaleDispatch dispatch) {
        this.grayScaleDispatch = dispatch;
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height) {
        return data;
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height, Rect rect) {
        int index;
        byte[] newByte = (byte[])data.clone();
        byte[] emptyByte = new byte[rect.width() * rect.height()];
        int areaSize = 0;
        double step = Math.random() * 2.0 + 1.0;
        int reductHeight = 0;
        float start_h = rect.top;
        while (start_h < (float)rect.bottom) {
            ++reductHeight;
            float start_w = rect.left;
            while (start_w < (float)rect.right) {
                index = (int)start_h * width + (int)start_w;
                emptyByte[areaSize] = newByte[index];
                ++areaSize;
                start_w = (float)((double)start_w + step);
            }
            start_h = (float)((double)start_h + step);
        }
        int reductWidth = areaSize / reductHeight;
        areaSize = 0;
        for (int start_h2 = rect.top; start_h2 < rect.bottom; ++start_h2) {
            for (int start_w = rect.left; start_w < rect.right; ++start_w) {
                index = start_h2 * width + start_w;
                int lef_w = (rect.width() - reductWidth) / 2 + rect.left;
                int rig_w = lef_w + reductWidth;
                int top_h = (rect.height() - reductHeight) / 2 + rect.top;
                int bot_h = top_h + reductHeight;
                newByte[index] = start_h2 >= top_h && start_h2 < bot_h && start_w >= lef_w && start_w < rig_w ? emptyByte[areaSize++] : -1;
            }
        }
        return this.grayScaleDispatch.dispatch(newByte, width, height, rect);
    }
}

