/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.grayscale;

import android.graphics.Rect;
import com.xshare.camera.grayscale.Dispatch;

class TranslationScale
implements Dispatch {
    int maxOffsetXRange;
    int maxOffsetYRange;

    TranslationScale(int maxOffsetXRange, int maxOffsetYRange) {
        this.maxOffsetXRange = maxOffsetXRange;
        this.maxOffsetYRange = maxOffsetYRange;
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height) {
        return data;
    }

    @Override
    public byte[] dispatch(byte[] data, int width, int height, Rect rect) {
        int offsetY;
        int offsetX;
        byte[] newByte = (byte[])data.clone();
        if (Math.random() > 0.5) {
            offsetX = (int)(Math.random() * -2.0 * (double)this.maxOffsetXRange + (double)this.maxOffsetXRange);
            offsetY = 0;
        } else {
            offsetX = 0;
            offsetY = (int)(Math.random() * -2.0 * (double)this.maxOffsetYRange + (double)this.maxOffsetYRange);
        }
        for (int i = rect.top; i < rect.bottom; ++i) {
            for (int j = rect.left; j < rect.right; ++j) {
                int current;
                int offset;
                if (offsetX >= 0 && offsetY >= 0) {
                    offset = (rect.bottom - i + rect.top - offsetY) * width + rect.right + rect.left - j - offsetX;
                    current = (rect.bottom + rect.top - i) * width + rect.right + rect.left - j;
                    newByte[current] = rect.bottom - i < offsetY || rect.right - j < offsetX ? -1 : newByte[offset];
                }
                if (offsetX >= 0 && offsetY <= 0) {
                    offset = (i - offsetY) * width + rect.right + rect.left - j - offsetX;
                    current = i * width + rect.right + rect.left - j;
                    newByte[current] = i > rect.bottom + offsetY || rect.right - j < offsetX ? -1 : newByte[offset];
                }
                if (offsetX <= 0 && offsetY >= 0) {
                    offset = (rect.bottom + rect.top - i - offsetY) * width + j - offsetX;
                    current = (rect.bottom + rect.top - i) * width + j;
                    newByte[current] = rect.bottom - i < offsetY || j > rect.right + offsetX ? -1 : newByte[offset];
                }
                if (offsetX > 0 || offsetY > 0) continue;
                offset = (i - offsetY) * width + j - offsetX;
                current = i * width + j;
                newByte[current] = i > rect.bottom + offsetY || j > rect.right + offsetX ? -1 : newByte[offset];
            }
        }
        return newByte;
    }
}

