/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.helper;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import androidx.annotation.FloatRange;

public class CameraHelper {
    static long startTime = 0L;

    public static boolean checkAutoFocus(CameraCharacteristics characteristics) {
        int[] afAvailableModes = new int[]{};
        if (Build.VERSION.SDK_INT >= 21) {
            afAvailableModes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        }
        return afAvailableModes.length != 0 && (afAvailableModes.length != 1 || afAvailableModes[0] != 0);
    }

    public static boolean matchCameraDirection(CameraCharacteristics cameraCharacteristics, int direction) {
        Integer facing = null;
        if (Build.VERSION.SDK_INT >= 21) {
            facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        }
        return facing != null && facing == direction;
    }

    public static Float getMinimumFocusDistance(CameraCharacteristics cameraCharacteristics) {
        Float distance = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                distance = (Float)cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return distance;
    }

    public static Float getMaxZoom(CameraCharacteristics cameraCharacteristics) {
        Float maxZoom = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxZoom;
    }

    public static Rect getZoomRect(CameraCharacteristics cameraCharacteristics, @FloatRange(from=0.0, to=1.0) float currentZoom) {
        Rect zoomRect;
        Float maxZoom;
        if ((currentZoom = currentZoom == 0.0f ? 1.0f : currentZoom * maxZoom.floatValue() + 1.0f) > (maxZoom = CameraHelper.getMaxZoom(cameraCharacteristics)).floatValue()) {
            currentZoom = maxZoom.floatValue();
        }
        if (currentZoom < 1.0f) {
            currentZoom = 1.0f;
        }
        Rect originReact = null;
        if (Build.VERSION.SDK_INT >= 21) {
            originReact = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        }
        try {
            if (originReact == null) {
                return null;
            }
            float ratio = 1.0f / currentZoom;
            int cropWidth = originReact.width() - Math.round((float)originReact.width() * ratio);
            int cropHeight = originReact.height() - Math.round((float)originReact.height() * ratio);
            zoomRect = new Rect(cropWidth / 2, cropHeight / 2, originReact.width() - cropWidth / 2, originReact.height() - cropHeight / 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            zoomRect = null;
        }
        return zoomRect;
    }

    public static byte[] readYuv(ImageReader reader) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Image image = null;
        image = reader.acquireLatestImage();
        if (image == null) {
            return null;
        }
        byte[] data = CameraHelper.getByteFromImage(image);
        image.close();
        return data;
    }

    private static byte[] getByteFromImage(Image image) {
        byte[] nv21 = null;
        try {
            if (Build.VERSION.SDK_INT < 19) {
                return null;
            }
            if (image == null || image.getPlanes() == null || image.getPlanes().length == 0) {
                return null;
            }
            Image.Plane[] planes = image.getPlanes();
            int remaining0 = planes[0].getBuffer().remaining();
            int remaining2 = planes[2].getBuffer().remaining();
            int w = image.getWidth();
            int h = image.getHeight();
            byte[] yRawSrcBytes = new byte[remaining0];
            byte[] uvRawSrcBytes = new byte[remaining2];
            nv21 = new byte[w * h * 3 / 2];
            planes[0].getBuffer().get(yRawSrcBytes);
            planes[2].getBuffer().get(uvRawSrcBytes);
            for (int i = 0; i < h; ++i) {
                int offset;
                System.arraycopy(yRawSrcBytes, planes[0].getRowStride() * i, nv21, w * i, w);
                if (i > image.getHeight() / 2 || (offset = w * (h + i)) + w >= nv21.length) continue;
                System.arraycopy(uvRawSrcBytes, planes[2].getRowStride() * i, nv21, offset, w);
            }
            return nv21;
        }
        catch (Exception e) {
            return nv21;
        }
    }

    public static void setZoom(@FloatRange(from=0.0, to=1.0) float z, Camera mCamera) {
        if (mCamera == null) {
            return;
        }
        Camera.Parameters p = mCamera.getParameters();
        if (p == null) {
            return;
        }
        if (!p.isZoomSupported()) {
            return;
        }
        int zoom = (int)(z * (float)p.getMaxZoom());
        if (zoom < 1) {
            zoom = 1;
        }
        p.setZoom(zoom);
        mCamera.setParameters(p);
    }

    public void checkFocusMode(CameraCharacteristics cameraCharacteristics) {
        int[] availableFocusModes = new int[]{};
        if (Build.VERSION.SDK_INT >= 21) {
            availableFocusModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        }
        for (int focusMode : availableFocusModes != null ? availableFocusModes : new int[]{}) {
            if (focusMode != 0 && focusMode != 2 && focusMode != 4 && focusMode != 1) continue;
        }
    }
}

