/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.helper;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageDecoder;
import android.net.Uri;
import android.os.Build;
import com.xshare.camera.Utils;
import com.xshare.camera.zxing.BitmapLuminanceSource;
import com.xshare.camera.zxing.CustomMultiFormatReader;
import com.xshare.camera.zxing.core.BinaryBitmap;
import com.xshare.camera.zxing.core.Result;
import com.xshare.camera.zxing.core.common.GlobalHistogramBinarizer;
import com.xshare.camera.zxing.core.common.HybridBinarizer;
import java.io.File;
import java.io.IOException;

public class ImgparseHelper {
    public static Result parseFile(Context context, String filePath) {
        Bitmap bitmap;
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            ImageDecoder.Source source = ImageDecoder.createSource((ContentResolver)context.getContentResolver(), (Uri)Utils.getMediaUriFromPath(context, filePath));
            try {
                bitmap = ImageDecoder.decodeBitmap((ImageDecoder.Source)source, (decoder, info, source1) -> {
                    decoder.setTargetSampleSize(2);
                    decoder.setMutableRequired(true);
                });
            }
            catch (IOException e) {
                bitmap = null;
            }
        } else {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = 2;
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        return ImgparseHelper.parseBitmap(bitmap);
    }

    public static Result parseBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        BitmapLuminanceSource source = new BitmapLuminanceSource(bitmap);
        Result result = CustomMultiFormatReader.getInstance().decode(new BinaryBitmap(new GlobalHistogramBinarizer(source)));
        if (result == null) {
            result = CustomMultiFormatReader.getInstance().decode(new BinaryBitmap(new HybridBinarizer(source)));
        }
        return result;
    }
}

