/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.helper;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import com.xshare.camera.zxing.core.BarcodeFormat;
import com.xshare.camera.zxing.core.EncodeHintType;
import com.xshare.camera.zxing.core.MultiFormatWriter;
import com.xshare.camera.zxing.core.common.BitMatrix;
import com.xshare.camera.zxing.core.qrcode.decoder.ErrorCorrectionLevel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002J&\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J5\u0010\u0012\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J7\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019JE\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/xshare/camera/helper/QRCodeEncoder;", "", "()V", "HINTS", "", "Lcom/xshare/camera/zxing/core/EncodeHintType;", "getHINTS", "()Ljava/util/Map;", "addLogoToQRCode", "Landroid/graphics/Bitmap;", "src", "logo", "showContent", "barcodeBitmap", "content", "", "textSize", "", "syncEncodeBarcode", "width", "height", "(Ljava/lang/String;IIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "syncEncodeQRCode", "size", "foregroundColor", "(Ljava/lang/String;IILandroid/graphics/Bitmap;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "backgroundColor", "(Ljava/lang/String;IIILandroid/graphics/Bitmap;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app_release"})
public final class QRCodeEncoder {
    @NotNull
    public static final QRCodeEncoder INSTANCE = new QRCodeEncoder();
    @NotNull
    private static final Map<EncodeHintType, Object> HINTS = new EnumMap(EncodeHintType.class);

    private QRCodeEncoder() {
    }

    @NotNull
    public final Map<EncodeHintType, Object> getHINTS() {
        return HINTS;
    }

    @Nullable
    public final Object syncEncodeQRCode(@Nullable String content, int size, int foregroundColor, @Nullable Bitmap logo, @NotNull Continuation<? super Bitmap> $completion) {
        return this.syncEncodeQRCode(content, size, foregroundColor, -1, logo, $completion);
    }

    @JvmOverloads
    @Nullable
    public final Object syncEncodeQRCode(@Nullable String content, int size, int foregroundColor, int backgroundColor, @Nullable Bitmap logo, @NotNull Continuation<? super Bitmap> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Bitmap>, Object>(content, size, foregroundColor, backgroundColor, logo, null){
            int label;
            final /* synthetic */ String $content;
            final /* synthetic */ int $size;
            final /* synthetic */ int $foregroundColor;
            final /* synthetic */ int $backgroundColor;
            final /* synthetic */ Bitmap $logo;
            {
                this.$content = $content;
                this.$size = $size;
                this.$foregroundColor = $foregroundColor;
                this.$backgroundColor = $backgroundColor;
                this.$logo = $logo;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Bitmap bitmap;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            BitMatrix matrix = new MultiFormatWriter().encode(this.$content, BarcodeFormat.QR_CODE, this.$size, this.$size, QRCodeEncoder.INSTANCE.getHINTS());
                            int[] pixels = new int[this.$size * this.$size];
                            int n = 0;
                            while (n < this.$size) {
                                int y = n++;
                                int n2 = 0;
                                while (n2 < this.$size) {
                                    int x;
                                    if (matrix.get(x = n2++, y)) {
                                        pixels[y * this.$size + x] = this.$foregroundColor;
                                        continue;
                                    }
                                    pixels[y * this.$size + x] = this.$backgroundColor;
                                }
                            }
                            Bitmap bitmap2 = Bitmap.createBitmap((int)this.$size, (int)this.$size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                            bitmap2.setPixels(pixels, 0, this.$size, 0, 0, this.$size, this.$size);
                            bitmap = QRCodeEncoder.access$addLogoToQRCode(QRCodeEncoder.INSTANCE, bitmap2, this.$logo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            bitmap = null;
                        }
                        return bitmap;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Bitmap> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object syncEncodeQRCode$default(QRCodeEncoder qRCodeEncoder, String string2, int n, int n2, int n3, Bitmap bitmap, Continuation continuation, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = -16777216;
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        if ((n4 & 0x10) != 0) {
            bitmap = null;
        }
        return qRCodeEncoder.syncEncodeQRCode(string2, n, n2, n3, bitmap, (Continuation<? super Bitmap>)continuation);
    }

    private final Bitmap addLogoToQRCode(Bitmap src, Bitmap logo) {
        if (src == null || logo == null) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        float scaleFactor = (float)srcWidth * 1.0f / (float)5 / (float)logoWidth;
        Bitmap bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        try {
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNull((Object)bitmap2);
            Canvas canvas = new Canvas(bitmap2);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            canvas.scale(scaleFactor, scaleFactor, (float)(srcWidth / 2), (float)(srcHeight / 2));
            canvas.drawBitmap(logo, (float)((srcWidth - logoWidth) / 2), (float)((srcHeight - logoHeight) / 2), null);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    @Nullable
    public final Object syncEncodeBarcode(@Nullable String content, int width, int height, int textSize, @NotNull Continuation<? super Bitmap> $completion) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        Map hints = new HashMap();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, Boxing.boxInt((int)0));
        try {
            Bitmap bitmap;
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.CODE_128, width, height, hints);
            int[] pixels = new int[width * height];
            int n = 0;
            while (n < height) {
                int y = n++;
                int n2 = 0;
                while (n2 < width) {
                    int x;
                    if (bitMatrix.get(x = n2++, y)) {
                        pixels[y * width + x] = -16777216;
                        continue;
                    }
                    pixels[y * width + x] = -1;
                }
            }
            Bitmap bitmap2 = bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNull((Object)bitmap2);
            bitmap2.setPixels(pixels, 0, width, 0, 0, width, height);
            if (textSize > 0) {
                bitmap = this.showContent(bitmap, content, textSize);
            }
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final Bitmap showContent(Bitmap barcodeBitmap, String content, int textSize) {
        if (TextUtils.isEmpty((CharSequence)content) || barcodeBitmap == null) {
            return null;
        }
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize((float)textSize);
        paint.setTextAlign(Paint.Align.CENTER);
        int textWidth = (int)paint.measureText(content);
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)(fm.bottom - fm.top);
        float scaleRateX = (float)barcodeBitmap.getWidth() * 1.0f / (float)textWidth;
        if (scaleRateX < 1.0f) {
            paint.setTextScaleX(scaleRateX);
        }
        int baseLine = barcodeBitmap.getHeight() + textHeight;
        Bitmap bitmap = Bitmap.createBitmap((int)barcodeBitmap.getWidth(), (int)(barcodeBitmap.getHeight() + 2 * textHeight), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas();
        canvas.drawColor(-1);
        canvas.setBitmap(bitmap);
        canvas.drawBitmap(barcodeBitmap, 0.0f, 0.0f, null);
        String string2 = content;
        Intrinsics.checkNotNull((Object)string2);
        canvas.drawText(string2, (float)(barcodeBitmap.getWidth() / 2), (float)baseLine, paint);
        canvas.save();
        canvas.restore();
        return bitmap;
    }

    @JvmOverloads
    @Nullable
    public final Object syncEncodeQRCode(@Nullable String content, int size, int foregroundColor, int backgroundColor, @NotNull Continuation<? super Bitmap> $completion) {
        return QRCodeEncoder.syncEncodeQRCode$default(this, content, size, foregroundColor, backgroundColor, null, $completion, 16, null);
    }

    @JvmOverloads
    @Nullable
    public final Object syncEncodeQRCode(@Nullable String content, int size, int foregroundColor, @NotNull Continuation<? super Bitmap> $completion) {
        return QRCodeEncoder.syncEncodeQRCode$default(this, content, size, foregroundColor, 0, null, $completion, 24, null);
    }

    @JvmOverloads
    @Nullable
    public final Object syncEncodeQRCode(@Nullable String content, int size, @NotNull Continuation<? super Bitmap> $completion) {
        return QRCodeEncoder.syncEncodeQRCode$default(this, content, size, 0, 0, null, $completion, 28, null);
    }

    public static final /* synthetic */ Bitmap access$addLogoToQRCode(QRCodeEncoder $this, Bitmap src, Bitmap logo) {
        return $this.addLogoToQRCode(src, logo);
    }

    static {
        HINTS.put(EncodeHintType.CHARACTER_SET, "utf-8");
        HINTS.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
        HINTS.put(EncodeHintType.MARGIN, 0);
    }
}

