/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.helper;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.xshare.camera.Config;
import com.xshare.camera.zxing.core.PlanarYUVLuminanceSource;
import com.xshare.camera.zxing.core.ResultPoint;

public class ScanHelper {
    public static RectF rotateUnCloseWise(RectF rect) {
        RectF rect1 = new RectF();
        rect1.left = rect.top;
        rect1.top = rect.left;
        rect1.right = rect.bottom;
        rect1.bottom = rect.right;
        return rect1;
    }

    private static RectF adapterRect(RectF rect) {
        RectF rect1 = new RectF();
        rect1.top = rect.left;
        rect1.right = rect.bottom;
        rect1.bottom = rect.right;
        rect1.left = rect.top;
        return rect1;
    }

    public static RectF adapter90(RectF rect) {
        rect = ScanHelper.adapterRect(rect);
        RectF rect1 = new RectF();
        rect1.left = 1.0f - rect.right;
        rect1.top = rect.top;
        rect1.right = 1.0f - rect.left;
        rect1.bottom = rect.bottom;
        return rect1;
    }

    public static RectF adapter270(RectF rectF) {
        rectF = ScanHelper.adapterRect(rectF);
        RectF rect1 = new RectF();
        rect1.left = rectF.left;
        rect1.top = 1.0f - rectF.bottom;
        rect1.right = rectF.right;
        rect1.bottom = 1.0f - rectF.top;
        return rect1;
    }

    public static Rect copyRect(Rect rect) {
        Rect result = new Rect();
        result.left = rect.left;
        result.top = rect.top;
        result.right = rect.right;
        result.bottom = rect.bottom;
        return result;
    }

    public static RectF copyRect(RectF rectF) {
        RectF result = new RectF();
        result.left = rectF.left;
        result.top = rectF.top;
        result.right = rectF.right;
        result.bottom = rectF.bottom;
        return result;
    }

    public static RectF scaleRectF(RectF rectF, float ratio) {
        RectF newRectF = ScanHelper.copyRect(rectF);
        newRectF.left -= (ratio - 1.0f) * newRectF.width() / 2.0f;
        newRectF.top -= (ratio - 1.0f) * newRectF.height() / 2.0f;
        newRectF.right += (ratio - 1.0f) * newRectF.width() / 2.0f;
        newRectF.bottom += (ratio - 1.0f) * newRectF.height() / 2.0f;
        if (newRectF.left < 0.0f || newRectF.left > 1.0f) {
            float f = newRectF.left = newRectF.left < 0.0f ? 0.0f : 1.0f;
        }
        if (newRectF.top < 0.0f || newRectF.top > 1.0f) {
            float f = newRectF.top = newRectF.top < 0.0f ? 0.0f : 1.0f;
        }
        if (newRectF.right < 0.0f || newRectF.right > 1.0f) {
            float f = newRectF.right = newRectF.right < 0.0f ? 0.0f : 1.0f;
        }
        if (newRectF.bottom < 0.0f || newRectF.bottom > 1.0f) {
            newRectF.bottom = newRectF.bottom < 0.0f ? 0.0f : 1.0f;
        }
        return newRectF;
    }

    public static Rect scaleRect(Rect rect, float ratio, int maxWidth, int maxHeight) {
        Rect newRect = ScanHelper.copyRect(rect);
        newRect.left = (int)((float)newRect.left - (ratio - 1.0f) * (float)newRect.width() / 2.0f);
        newRect.top = (int)((float)newRect.top - (ratio - 1.0f) * (float)newRect.height() / 2.0f);
        newRect.right = (int)((float)newRect.right + (ratio - 1.0f) * (float)newRect.width() / 2.0f);
        newRect.bottom = (int)((float)newRect.bottom + (ratio - 1.0f) * (float)newRect.height() / 2.0f);
        if (newRect.left < 0 || newRect.left > maxWidth) {
            int n = newRect.left = newRect.left < 0 ? 0 : maxWidth;
        }
        if (newRect.top < 0 || newRect.top > maxHeight) {
            int n = newRect.top = newRect.top < 0 ? 0 : maxHeight;
        }
        if (newRect.right < 0 || newRect.right > maxWidth) {
            int n = newRect.right = newRect.right < 0 ? 0 : maxWidth;
        }
        if (newRect.bottom < 0 || newRect.bottom > maxHeight) {
            newRect.bottom = newRect.bottom < 0 ? 0 : maxHeight;
        }
        return newRect;
    }

    public static PointF[] rotatePoint(ResultPoint[] point) {
        float aspeY;
        float aspeX;
        if (point == null || point.length == 0) {
            return null;
        }
        if (Config.scanRect.getScanR() == null) {
            return null;
        }
        float preX = Config.scanRect.getPreX();
        float preY = Config.scanRect.getPreY();
        float extraX = Config.scanRect.getExtraX();
        float extraY = Config.scanRect.getExtraY();
        if (Config.is90() || Config.is270()) {
            aspeX = (preX + extraX) / (float)Config.scanRect.getDataX();
            aspeY = (preY + extraY) / (float)Config.scanRect.getDataY();
        } else {
            aspeX = (preX + extraX) / (float)Config.scanRect.getDataY();
            aspeY = (preY + extraY) / (float)Config.scanRect.getDataX();
        }
        PointF[] pointFS = new PointF[point.length];
        for (int i = 0; i < point.length; ++i) {
            float relatPointY;
            float relatPointX;
            if (Config.is90()) {
                relatPointX = ((float)Config.scanRect.getScanR().left + point[i].getX()) * aspeX - extraX / 2.0f;
                relatPointY = ((float)Config.scanRect.getScanR().top + point[i].getY()) * aspeY - extraY / 2.0f;
            } else if (Config.is270()) {
                relatPointX = preX - ((float)Config.scanRect.getScanR().left + point[i].getX()) * aspeX + extraX / 2.0f;
                relatPointY = preY - ((float)Config.scanRect.getScanR().top + point[i].getY()) * aspeY + extraY / 2.0f;
            } else {
                relatPointX = preX + extraX / 2.0f - ((float)Config.scanRect.getScanR().top + point[i].getY()) * aspeX;
                relatPointY = ((float)Config.scanRect.getScanR().left + point[i].getX()) * aspeY - extraY / 2.0f;
            }
            pointFS[i] = new PointF(relatPointX, relatPointY);
        }
        return pointFS;
    }

    public static PointF[] rotatePointR(ResultPoint[] point) {
        float aspeY;
        float aspeX;
        if (point == null || point.length == 0) {
            return null;
        }
        if (Config.scanRect.getScanR() == null) {
            return null;
        }
        float preX = Config.scanRect.getPreX();
        float preY = Config.scanRect.getPreY();
        float extraX = Config.scanRect.getExtraX();
        float extraY = Config.scanRect.getExtraY();
        if (Config.is90() || Config.is270()) {
            aspeX = (preX + extraX) / (float)Config.scanRect.getDataX();
            aspeY = (preY + extraY) / (float)Config.scanRect.getDataY();
        } else {
            aspeX = (preX + extraX) / (float)Config.scanRect.getDataY();
            aspeY = (preY + extraY) / (float)Config.scanRect.getDataX();
        }
        PointF[] pointFS = new PointF[point.length];
        for (int i = 0; i < point.length; ++i) {
            float relatPointY;
            float relatPointX;
            if (Config.is90()) {
                relatPointX = ((float)Config.scanRect.getScanR().left + point[i].getY()) * aspeX - extraX / 2.0f;
                relatPointY = ((float)Config.scanRect.getScanR().top + point[i].getX()) * aspeY - extraY / 2.0f;
            } else if (Config.is270()) {
                relatPointX = preX - ((float)Config.scanRect.getScanR().left + point[i].getY()) * aspeX + extraX / 2.0f;
                relatPointY = preY - ((float)Config.scanRect.getScanR().top + point[i].getX()) * aspeY + extraY / 2.0f;
            } else {
                relatPointX = preX + extraX / 2.0f - ((float)Config.scanRect.getScanR().top + point[i].getX()) * aspeX;
                relatPointY = ((float)Config.scanRect.getScanR().left + point[i].getY()) * aspeY - extraY / 2.0f;
            }
            pointFS[i] = new PointF(relatPointX, relatPointY);
        }
        return pointFS;
    }

    public static int calQrLenghtShow(ResultPoint[] point) {
        if (point == null || point.length == 0) {
            return 0;
        }
        PointF avargPoint = new PointF();
        for (ResultPoint item : point) {
            avargPoint.x += Math.abs(item.getX());
            avargPoint.y += Math.abs(item.getY());
        }
        avargPoint.x /= (float)point.length;
        avargPoint.y /= (float)point.length;
        int x = (int)Math.pow(avargPoint.x - point[0].getX(), 2.0);
        int y = (int)Math.pow(avargPoint.y - point[0].getY(), 2.0);
        float asp = (float)Math.max(Config.scanRect.getPreX(), Config.scanRect.getPreY()) / (float)Math.max(Config.scanRect.getDataX(), Config.scanRect.getDataY());
        return (int)(Math.sqrt(x + y) / Math.sqrt(2.0) * 2.0 * (double)asp);
    }

    public static PointF calCenterPointF(PointF[] point) {
        if (point == null || point.length == 0) {
            return new PointF();
        }
        PointF avargPoint = new PointF();
        for (PointF item : point) {
            avargPoint.x += Math.abs(item.x);
            avargPoint.y += Math.abs(item.y);
        }
        avargPoint.x /= (float)point.length;
        avargPoint.y /= (float)point.length;
        return avargPoint;
    }

    public static float calQrRotate(PointF[] point) {
        if (null == point) {
            return 0.0f;
        }
        PointF avargPoint = ScanHelper.calCenterPointF(point);
        int x = (int)Math.abs(avargPoint.x - point[0].x);
        int y = (int)Math.abs(avargPoint.y - point[0].y);
        float maxRotate = (float)((double)((float)Math.atan2(x, y) / 2.0f) / Math.PI * 360.0);
        return maxRotate - 45.0f;
    }

    public static PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height, Rect rect) {
        if (rect.left == 0 && rect.right == 0 || rect.top == 0 && rect.bottom == 0) {
            try {
                throw new Exception("\u626b\u7801\u89e3\u6790\u533a\u57df\u5f02\u5e38");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height());
    }

    public static Rect getScanByteRect(int dataWidth, int dataHeight) {
        try {
            if (Config.scanRect.getRect() == null) {
                return new Rect(0, 0, 0, 0);
            }
            RectF cropRect = Config.scanRect.getRect();
            if (dataWidth >= dataHeight) {
                if (Config.scanRect.getScanR() == null) {
                    Config.scanRect.setScanR(new Rect());
                    Config.scanRect.getScanR().left = (int)(cropRect.top * (float)dataWidth);
                    Config.scanRect.getScanR().top = (int)((1.0f - cropRect.right) * (float)dataHeight);
                    Config.scanRect.getScanR().right = (int)(cropRect.bottom * (float)dataWidth);
                    Config.scanRect.getScanR().bottom = (int)((1.0f - cropRect.left) * (float)dataHeight);
                }
                return Config.scanRect.getScanR();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Rect(0, 0, 0, 0);
    }

    public static int getQrLenght(ResultPoint[] point) {
        if (Config.scanRect.getScanR() == null) {
            return 0;
        }
        if (point.length < 3) {
            return 0;
        }
        PointF avargPoint = new PointF();
        for (ResultPoint item : point) {
            avargPoint.x += item.getX();
            avargPoint.y += item.getY();
        }
        avargPoint.x /= (float)point.length;
        avargPoint.y /= (float)point.length;
        int sideA = (int)(avargPoint.x - point[0].getX());
        int sideB = (int)(avargPoint.y - point[0].getY());
        float preX = Config.scanRect.getPreX();
        float aspX = preX / (float)Config.scanRect.getScanR().height();
        return (int)(Math.sqrt(sideA * sideA + sideB * sideB) / Math.sqrt(2.0) * 2.0 * (double)aspX);
    }
}

