/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;

public class VibrateHelper {
    private static final float BEEP_VOLUME = 0.5f;
    private static final int VIBRATE_DURATION = 10;
    private static SoundPool soundPool;
    private static int voiceId;

    public static void playBeep() {
        if (soundPool != null) {
            soundPool.play(voiceId, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }

    public static void playInit() {
        if (soundPool != null) {
            soundPool.release();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            SoundPool.Builder builder = new SoundPool.Builder();
            builder.setMaxStreams(1);
            AudioAttributes.Builder attrBuilder = new AudioAttributes.Builder();
            attrBuilder.setLegacyStreamType(3);
            builder.setAudioAttributes(attrBuilder.build());
            soundPool = builder.build();
        } else {
            soundPool = new SoundPool(1, 3, 0);
        }
    }

    public static void playVibrate(Context context) {
        RxVibrateTool.vibrateOnce(context, 10);
    }

    public static void stopVibrate() {
        RxVibrateTool.vibrateStop();
    }

    private static class RxVibrateTool {
        private static Vibrator vibrator;

        private RxVibrateTool() {
        }

        @SuppressLint(value={"MissingPermission"})
        static void vibrateOnce(Context context, int millisecond) {
            vibrator = (Vibrator)context.getSystemService("vibrator");
            try {
                if (Build.VERSION.SDK_INT >= 26) {
                    vibrator.vibrate(VibrationEffect.createOneShot((long)millisecond, (int)25));
                } else {
                    vibrator.vibrate((long)millisecond);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @SuppressLint(value={"MissingPermission"})
        public static void vibrateComplicated(Context context, long[] pattern, int repeate) {
            vibrator = (Vibrator)context.getSystemService("vibrator");
            vibrator.vibrate(pattern, repeate);
        }

        @SuppressLint(value={"MissingPermission"})
        public static void vibrateStop() {
            if (vibrator != null) {
                vibrator.cancel();
                vibrator = null;
            }
        }
    }
}

