/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.view;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import com.xshare.camera.Config;
import com.xshare.camera.Result;
import com.xshare.camera.able.AbleManager;
import com.xshare.camera.camera.AspectRatio;
import com.xshare.camera.cameraview.BaseCameraView;
import com.xshare.camera.cameraview.CameraView;
import com.xshare.camera.helper.ImgparseHelper;
import com.xshare.camera.helper.VibrateHelper;
import com.xshare.camera.helper.ZoomHelper;
import com.xshare.camera.view.FreeInterface;
import com.xshare.camera.view.ScanBarCallBack;
import com.xshare.camera.view.ScanLightViewCallBack;
import com.xshare.camera.zxing.ScanTypeConfig;
import com.xshare.trans.R;
import java.lang.ref.WeakReference;

public abstract class FreeZxingView
extends BaseCameraView
implements Handler.Callback,
FreeInterface {
    private AbleManager ableCollect;
    private BusHandler busHandle;
    private ScanBarCallBack scanBarView;
    private ScanLightViewCallBack lightView;
    private View parseRect;

    public FreeZxingView(Context context) {
        this(context, null);
    }

    public FreeZxingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FreeZxingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setFacing(0);
        this.initScanType();
        HandlerThread thread = new HandlerThread("BusHandle", 0);
        thread.start();
        this.busHandle = new BusHandler(this, thread.getLooper());
    }

    @Override
    protected AspectRatio provideAspectRatio() {
        return AspectRatio.of(16, 9);
    }

    public boolean handleMessage(@NonNull Message msg) {
        Message message = Message.obtain((Message)msg);
        this.post(() -> {
            switch (message.what) {
                case 0: {
                    if (!(message.obj instanceof Result)) break;
                    Result result = (Result)message.obj;
                    this.showQRLoc(result);
                    break;
                }
                case 1: {
                    if (this.lightView == null) break;
                    if (Boolean.parseBoolean(message.obj.toString())) {
                        this.lightView.lightDark();
                        break;
                    }
                    this.lightView.lightBrighter();
                    break;
                }
                case 2: {
                    this.setZoom(Float.valueOf(Float.parseFloat(message.obj.toString())));
                    break;
                }
            }
        });
        return true;
    }

    @Override
    public void onPreviewByteBack(CameraView camera, byte[] data) {
        super.onPreviewByteBack(camera, data);
        if (this.ableCollect != null) {
            this.ableCollect.cusAction(data, Config.scanRect.getDataX(), Config.scanRect.getDataY());
        }
    }

    public void scanSucHelper() {
        this.onCameraPause();
        this.ableCollect.clear();
        this.scanBarView.stopScanAnimator();
        VibrateHelper.playVibrate(this.getContext());
        VibrateHelper.playBeep();
    }

    @Override
    public void onCreate(@NonNull LifecycleOwner owner) {
        super.onCreate(owner);
        this.ableCollect = AbleManager.createInstance(this.busHandle);
    }

    @Override
    public void onPause(@NonNull LifecycleOwner owner) {
        super.onPause(owner);
        this.busHandle.enable(false);
        this.busHandle.removeCallbacksAndMessages(null);
        this.ableCollect.clear();
        if (this.scanBarView != null) {
            this.scanBarView.stopScanAnimator();
        }
    }

    @Override
    public void onDestroy(@NonNull LifecycleOwner owner) {
        super.onDestroy(owner);
        if (this.busHandle != null) {
            this.busHandle.removeCallbacksAndMessages(null);
            if (null != this.busHandle.getLooper()) {
                this.busHandle.getLooper().quit();
            }
        }
        if (this.ableCollect != null) {
            this.ableCollect.release();
        }
        VibrateHelper.stopVibrate();
    }

    public void showQRLoc(Result result) {
        this.resultBack(result);
    }

    private void cameraStartLaterConfig() {
        if (this.scanBarView != null) {
            this.scanBarView.cameraStartLaterInit();
        }
        if (this.lightView != null) {
            this.lightView.cameraStartLaterInit();
        }
        this.post(() -> this.defineScanParseRect(this.parseRect));
        if (this.lightView != null) {
            this.lightView.regLightOperator(() -> this.lightOperator(true), () -> this.lightOperator(false));
        }
        this.lightOperator(false);
        if (this.scanBarView != null) {
            this.scanBarView.startScanAnimator();
        }
        if (this.ableCollect != null) {
            this.ableCollect.loadAbility();
        }
        this.busHandle.enable(true);
        VibrateHelper.playInit();
    }

    public abstract void resultBack(Result var1);

    protected void resultBackFile() {
    }

    @Override
    public void onCameraOpenBack(CameraView camera) {
        View view = this.findViewById(R.id.provideViewId);
        this.removeView(view);
        View inflate = LayoutInflater.from((Context)this.getContext()).inflate(this.provideFloorView(), (ViewGroup)this, false);
        inflate.setId(R.id.provideViewId);
        this.addView(inflate);
        this.parseRect = this.provideParseRectView();
        this.scanBarView = this.provideScanBarView();
        this.lightView = this.provideLightView();
        this.cameraStartLaterConfig();
    }

    public abstract int provideFloorView();

    private void initScanType() {
        Config.scanTypeConfig = this.configScanType();
        Config.isSupportBlackEdge = this.isSupportBlackEdgeQrScan();
    }

    @Override
    public void onCameraCloseBack(CameraView camera) {
        ZoomHelper.close(this);
    }

    protected void parseFile(String filePath) {
        this.proscribeCamera();
        this.busHandle.removeCallbacksAndMessages(null);
        this.busHandle.post(() -> this.onParseResult(ImgparseHelper.parseFile(this.getContext(), filePath)));
    }

    private void onParseResult(com.xshare.camera.zxing.core.Result result) {
        if (result != null && !TextUtils.isEmpty((CharSequence)result.getText())) {
            this.mainHand.post(() -> {
                this.resultBackFile();
                this.scanSucHelper();
            });
        } else {
            this.mainHand.post(() -> {
                this.resultBackFile();
                this.unProscibeCamera();
            });
        }
    }

    public ScanTypeConfig configScanType() {
        return ScanTypeConfig.HIGH_FREQUENCY;
    }

    public Boolean isSupportBlackEdgeQrScan() {
        return true;
    }

    static class BusHandler
    extends Handler {
        boolean hasResult = false;
        WeakReference<Handler.Callback> viewReference;

        public BusHandler(Handler.Callback view, Looper loop) {
            super(loop);
            this.viewReference = new WeakReference<Handler.Callback>(view);
        }

        public void handleMessage(@NonNull Message msg) {
            if (!this.hasResult) {
                return;
            }
            if (msg.what == 0) {
                this.enable(true);
                this.removeCallbacksAndMessages(null);
            }
            ((Handler.Callback)this.viewReference.get()).handleMessage(msg);
        }

        public void enable(Boolean enable) {
            this.hasResult = enable;
        }
    }
}

