/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.xshare.camera.zxing.core.ResultPoint;
import com.xshare.trans.R;

public final class ViewfinderView
extends View {
    private int mFrameWidth;
    private int mSideWidth;
    private final Paint paint = new Paint(1);
    private final Paint mSidePaint = new Paint();
    private final int maskColor;
    private final Rect mFrameRect;
    private Rect mFrameRect2;
    private Bitmap mFrameRectbg;
    private int offerNUm = 0;

    public ViewfinderView(Context context) {
        this(context, null);
    }

    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources resources = this.getResources();
        this.maskColor = resources.getColor(R.color.viewfinder_mask2);
        this.mFrameRectbg = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.finderview_bg);
        this.paint.setColor(this.maskColor);
        this.offerNUm = (int)this.getResources().getDimension(R.dimen.dp_6);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ViewfinderView);
        this.mFrameWidth = array.getDimensionPixelSize(R.styleable.ViewfinderView_frameWidth, 0);
        this.mSideWidth = array.getDimensionPixelSize(R.styleable.ViewfinderView_sideWidth, 0);
        int windowWidth = resources.getDisplayMetrics().widthPixels;
        if (this.mFrameWidth > windowWidth) {
            this.mFrameWidth = windowWidth - 30;
        }
        if (this.mSideWidth > this.mFrameWidth) {
            throw new IllegalArgumentException("Side width can not be greater than the width of the frame!");
        }
        int leftOffset = (windowWidth - this.mFrameWidth) / 2;
        int topOffset = array.getDimensionPixelSize(R.styleable.ViewfinderView_frameTopOffset, 0);
        this.mFrameRect = new Rect(leftOffset, topOffset, leftOffset + this.mFrameWidth, topOffset + this.mFrameWidth);
        this.mFrameRect2 = new Rect(leftOffset - this.offerNUm, topOffset - this.offerNUm, leftOffset + this.mFrameWidth + this.offerNUm, topOffset + this.mFrameWidth + this.offerNUm);
        array.recycle();
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)this.mFrameRect.top, this.paint);
        canvas.drawRect(0.0f, (float)this.mFrameRect.top, (float)this.mFrameRect.left, (float)(this.mFrameRect.bottom + 1), this.paint);
        canvas.drawRect((float)(this.mFrameRect.right + 1), (float)this.mFrameRect.top, (float)width, (float)(this.mFrameRect.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(this.mFrameRect.bottom + 1), (float)width, (float)height, this.paint);
        if (this.mFrameRectbg != null && !this.mFrameRectbg.isRecycled()) {
            canvas.drawBitmap(this.mFrameRectbg, null, this.mFrameRect2, this.mSidePaint);
        }
    }

    public void release() {
        if (this.mFrameRectbg != null && !this.mFrameRectbg.isRecycled()) {
            this.mFrameRectbg.recycle();
            this.mFrameRectbg = null;
        }
    }

    public void drawViewfinder() {
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
    }
}

