/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.view.style1;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import com.xshare.camera.Result;
import com.xshare.camera.view.ScanLocViewCallBack;
import com.xshare.trans.R;

public class LocationView
extends AppCompatImageView
implements ScanLocViewCallBack {
    public LocationView(@NonNull Context context) {
        this(context, null);
    }

    public LocationView(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LocationView(@NonNull Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void toLocation(Result result, final Runnable runnable) {
        PointF qrPoint = result.getQrPointF();
        this.setVisibility(0);
        this.setTranslationX(qrPoint.x - (float)(this.getLayoutParams().width >> 1));
        this.setTranslationY(qrPoint.y - (float)(this.getLayoutParams().height >> 1));
        this.setScaleX(0.0f);
        this.setScaleY(0.0f);
        this.animate().scaleX(1.0f).scaleY(1.0f).setDuration(300L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                runnable.run();
            }
        }).start();
    }

    @Override
    public void cameraStartLaterInit() {
        this.setVisibility(8);
        this.setImageResource(R.drawable.ic_qr_loc);
    }
}

