/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.view.style1;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.xshare.trans.R;

public class MaskView
extends View {
    private Paint paint;
    private Rect clearRect = new Rect();
    private Rect[] drawRects;
    private float margin_left;
    private float margin_top;
    private float margin_right;
    private float margin_bottom;
    private int id;
    private int bgColor;

    public MaskView(Context context) {
        this(context, null);
    }

    public MaskView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaskView);
        this.id = typedArray.getResourceId(R.styleable.MaskView_camera_clearById, 0);
        this.margin_left = typedArray.getDimension(R.styleable.MaskView_camera_clear_margin_left, 0.0f);
        this.margin_top = typedArray.getDimension(R.styleable.MaskView_camera_clear_margin_top, 0.0f);
        this.margin_right = typedArray.getDimension(R.styleable.MaskView_camera_clear_margin_right, 0.0f);
        this.margin_bottom = typedArray.getDimension(R.styleable.MaskView_camera_clear_margin_bottom, 0.0f);
        this.bgColor = typedArray.getColor(R.styleable.MaskView_camera_maskBgColor, Color.parseColor((String)"#1f000000"));
        this.paint.setColor(this.bgColor);
        typedArray.recycle();
    }

    private Rect[] clearRect2Rect() {
        Rect[] rects = new Rect[]{new Rect(0, 0, this.getMeasuredWidth(), this.clearRect.top), new Rect(0, this.clearRect.top, this.clearRect.left, this.clearRect.bottom), new Rect(this.clearRect.right, this.clearRect.top, this.getMeasuredWidth(), this.clearRect.bottom), new Rect(0, this.clearRect.bottom, this.getMeasuredWidth(), this.getMeasuredHeight())};
        return rects;
    }

    public void initPaint() {
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.post(() -> {
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            View parseRectView = viewGroup.findViewById(this.id);
            if (parseRectView != null) {
                int[] parse_screen = new int[2];
                parseRectView.getLocationOnScreen(parse_screen);
                int[] parent_screen = new int[2];
                viewGroup.getLocationInWindow(parent_screen);
                this.clearRect.left = parse_screen[0] - parent_screen[0];
                this.clearRect.top = parse_screen[1] - parent_screen[1];
                this.clearRect.right = parse_screen[0] - parent_screen[0] + parseRectView.getMeasuredWidth();
                this.clearRect.bottom = parse_screen[1] - parent_screen[1] + parseRectView.getMeasuredHeight();
            } else {
                this.clearRect.left = (int)this.margin_left;
                this.clearRect.top = (int)this.margin_top;
                this.clearRect.right = (int)((float)this.getMeasuredWidth() - this.margin_right);
                this.clearRect.bottom = (int)((float)this.getMeasuredHeight() - this.margin_bottom);
            }
            this.drawRects = this.clearRect2Rect();
            this.invalidate();
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.clearRect == null) {
            return;
        }
        if (this.drawRects != null) {
            for (Rect rect : this.drawRects) {
                canvas.drawRect(rect, this.paint);
            }
        }
    }

    public void setClearRect(Rect rect) {
        this.clearRect = rect;
        this.invalidate();
    }

    public void setMaskingColor(@ColorInt int color2) {
        this.paint.setColor(color2);
        this.invalidate();
    }
}

