/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.view.style1;

import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.xshare.camera.Utils;
import com.xshare.camera.view.ScanBarCallBack;

public class ScanBarView
extends FrameLayout
implements ScanBarCallBack {
    private float BAR_HEIGHT = Utils.dp2Px(this.getContext(), Float.valueOf(20.0f));
    private float ALPHA_LENGTH = 0.2f;
    private ValueAnimator animator;
    private ImageView barView;

    public ScanBarView(Context context) {
        super(context);
        this.initView();
    }

    public ScanBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ScanBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.barView = new ImageView(this.getContext());
        this.barView.setLayoutParams(new ViewGroup.LayoutParams(-1, (int)this.BAR_HEIGHT));
        this.addView((View)this.barView);
        this.animator = ValueAnimator.ofFloat((float[])new float[]{-this.BAR_HEIGHT, this.getMeasuredHeight()}).setDuration(4000L);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.startAnim();
    }

    public void startAnim() {
        if (this.animator != null && this.animator.isRunning()) {
            return;
        }
        if (this.getMeasuredHeight() == 0) {
            return;
        }
        float alpha_height = this.ALPHA_LENGTH * (float)this.getMeasuredHeight();
        this.setVisibility(0);
        this.animator.addUpdateListener(animation -> {
            Object animatedValue = animation.getAnimatedValue();
            if (animatedValue instanceof Float) {
                float value = ((Float)animatedValue).floatValue();
                if (value <= alpha_height) {
                    this.barView.setAlpha(value / alpha_height);
                } else {
                    this.barView.setAlpha(((float)this.getMeasuredHeight() - value) / alpha_height);
                }
            }
        });
        this.animator.setRepeatCount(0x7FFFFFFE);
        this.animator.setRepeatMode(1);
        this.animator.start();
    }

    public void stopAnim() {
        if (this.animator != null) {
            this.setVisibility(4);
            this.animator.cancel();
        }
    }

    @Override
    public void startScanAnimator() {
        this.startAnim();
    }

    @Override
    public void stopScanAnimator() {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnim();
    }

    @Override
    public void cameraStartLaterInit() {
        this.stopAnim();
    }
}

