/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.view.style1;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.xshare.camera.view.ScanLightViewCallBack;
import com.xshare.trans.R;

public class ScanLightView
extends FrameLayout
implements ScanLightViewCallBack {
    private TextView tv;
    private ImageView iv;
    private boolean isOpen;
    Runnable open;
    Runnable close;

    public ScanLightView(Context context) {
        super(context);
        this.initView();
    }

    public ScanLightView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ScanLightView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.light_layout, null);
        this.iv = (ImageView)v.findViewById(R.id.light_img);
        this.tv = (TextView)v.findViewById(R.id.light_text);
        this.addView(v);
        this.setOnClickListener(v1 -> this.toggle());
        this.setVisibility(8);
    }

    public void toggle() {
        if (this.tv.getText().equals("\u8f7b\u89e6\u7167\u4eae")) {
            this.open();
        } else {
            this.close();
        }
    }

    private void open() {
        if (this.open != null) {
            this.open.run();
        }
        this.isOpen = true;
        this.tv.setText((CharSequence)"\u8f7b\u89e6\u5173\u95ed");
    }

    private void close() {
        if (this.close != null) {
            this.close.run();
        }
        this.isOpen = false;
        this.tv.setText((CharSequence)"\u8f7b\u89e6\u7167\u4eae");
    }

    @Override
    public void lightBrighter() {
        this.setVisibility(0);
    }

    @Override
    public void lightDark() {
        if (!this.isOpen) {
            this.setVisibility(8);
        }
    }

    @Override
    public void regLightOperator(Runnable open, Runnable close) {
        this.open = open;
        this.close = close;
    }

    @Override
    public void cameraStartLaterInit() {
        this.close();
        this.setVisibility(8);
    }
}

