/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.view.style2;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import com.xshare.camera.Result;
import com.xshare.camera.view.ScanLocViewCallBack;

public class LocationView
extends AppCompatImageView
implements ScanLocViewCallBack {
    public LocationView(@NonNull Context context) {
        this(context, null);
    }

    public LocationView(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LocationView(@NonNull Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void toLocation(Result result, Runnable runnable) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (result != null) {
            this.setTranslationX(result.getQrPointF().x - (float)result.getQrLeng() * 1.0f);
            this.setTranslationY(result.getQrPointF().y - (float)result.getQrLeng() * 1.0f);
            this.setRotation(result.getQrRotate());
            params.width = (int)((float)result.getQrLeng() * 2.0f);
            params.height = (int)((float)result.getQrLeng() * 2.0f);
            if (params instanceof FrameLayout.LayoutParams) {
                FrameLayout.LayoutParams fp = (FrameLayout.LayoutParams)params;
                fp.gravity = 0x800033;
            }
            this.setLayoutParams(params);
            runnable.run();
        }
    }

    @Override
    public void cameraStartLaterInit() {
        this.startAnim();
    }

    public void startAnim() {
        PropertyValuesHolder scaleYProper = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.8f, 1.0f});
        PropertyValuesHolder scaleXProper = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.8f, 1.0f});
        ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)this, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleYProper, scaleXProper});
        animator.setRepeatMode(1);
        animator.setDuration(2000L);
        animator.setRepeatCount(0x7FFFFFFE);
        animator.start();
    }
}

