/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing;

import com.xshare.camera.Config;
import com.xshare.camera.zxing.QRTypeConfig;
import com.xshare.camera.zxing.ScanTypeConfig;
import com.xshare.camera.zxing.core.BarcodeFormat;
import com.xshare.camera.zxing.core.BinaryBitmap;
import com.xshare.camera.zxing.core.DecodeHintType;
import com.xshare.camera.zxing.core.NotFoundException;
import com.xshare.camera.zxing.core.Reader;
import com.xshare.camera.zxing.core.ReaderException;
import com.xshare.camera.zxing.core.Result;
import com.xshare.camera.zxing.core.aztec.AztecReader;
import com.xshare.camera.zxing.core.datamatrix.DataMatrixReader;
import com.xshare.camera.zxing.core.maxicode.MaxiCodeReader;
import com.xshare.camera.zxing.core.oned.MultiFormatOneDReader;
import com.xshare.camera.zxing.core.pdf417.PDF417Reader;
import com.xshare.camera.zxing.core.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class CustomMultiFormatReader
implements Reader {
    private Map<DecodeHintType, ?> hints;
    private Reader[] readers;
    private ScanTypeConfig mBarcodeType;
    static CustomMultiFormatReader customMultiFormatReader;

    @Override
    public Result decode(BinaryBitmap image) {
        return this.decodeInternal(image);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        return this.decodeInternal(image);
    }

    public Result decodeWithState(BinaryBitmap image) throws NotFoundException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(image);
    }

    public void setHints(Map<DecodeHintType, ?> hints) {
        this.hints = hints;
        boolean tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER);
        Collection formats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Reader> readers = new ArrayList<Reader>();
        if (formats != null) {
            boolean addOneDReader;
            boolean bl = addOneDReader = formats.contains((Object)BarcodeFormat.UPC_A) || formats.contains((Object)BarcodeFormat.UPC_E) || formats.contains((Object)BarcodeFormat.EAN_13) || formats.contains((Object)BarcodeFormat.EAN_8) || formats.contains((Object)BarcodeFormat.CODABAR) || formats.contains((Object)BarcodeFormat.CODE_39) || formats.contains((Object)BarcodeFormat.CODE_93) || formats.contains((Object)BarcodeFormat.CODE_128) || formats.contains((Object)BarcodeFormat.ITF) || formats.contains((Object)BarcodeFormat.RSS_14) || formats.contains((Object)BarcodeFormat.RSS_EXPANDED);
            if (addOneDReader && !tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
            if (formats.contains((Object)BarcodeFormat.QR_CODE)) {
                readers.add(new QRCodeReader());
            }
            if (formats.contains((Object)BarcodeFormat.DATA_MATRIX)) {
                readers.add(new DataMatrixReader());
            }
            if (formats.contains((Object)BarcodeFormat.AZTEC)) {
                readers.add(new AztecReader());
            }
            if (formats.contains((Object)BarcodeFormat.PDF_417)) {
                readers.add(new PDF417Reader());
            }
            if (formats.contains((Object)BarcodeFormat.MAXICODE)) {
                readers.add(new MaxiCodeReader());
            }
            if (addOneDReader && tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
        }
        if (readers.isEmpty()) {
            if (!tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
            readers.add(new QRCodeReader());
            readers.add(new DataMatrixReader());
            readers.add(new AztecReader());
            readers.add(new PDF417Reader());
            readers.add(new MaxiCodeReader());
            if (tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
        }
        this.readers = readers.toArray(new Reader[readers.size()]);
    }

    @Override
    public void reset() {
        if (this.readers != null) {
            for (Reader reader : this.readers) {
                reader.reset();
            }
        }
    }

    private Result decodeInternal(BinaryBitmap image) {
        Result resultFinal = null;
        if (this.readers != null) {
            for (Reader reader : this.readers) {
                try {
                    Result result = reader.decode(image, this.hints);
                    if (result != null) {
                        resultFinal = result;
                    }
                    if (result != null && result.getText() != null) {
                        return resultFinal;
                    }
                }
                catch (ReaderException readerException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return resultFinal;
    }

    public void setType(ScanTypeConfig barcodeType, Map<DecodeHintType, Object> hintMap) {
        this.mBarcodeType = barcodeType;
        this.hints = hintMap;
        if (barcodeType == ScanTypeConfig.CUSTOM && (hintMap == null || hintMap.isEmpty())) {
            throw new RuntimeException("barcodeType \u4e3a BarcodeType.CUSTOM \u65f6 hintMap \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setupReader();
    }

    protected void setupReader() {
        if (this.mBarcodeType == ScanTypeConfig.ONE_DIMENSION) {
            this.setHints(QRTypeConfig.ONE_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.TWO_DIMENSION) {
            this.setHints(QRTypeConfig.TWO_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_QR_CODE) {
            this.setHints(QRTypeConfig.QR_CODE_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_CODE_128) {
            this.setHints(QRTypeConfig.CODE_128_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.ONLY_EAN_13) {
            this.setHints(QRTypeConfig.EAN_13_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.HIGH_FREQUENCY) {
            this.setHints(QRTypeConfig.HIGH_FREQUENCY_HINT_MAP);
        } else if (this.mBarcodeType == ScanTypeConfig.CUSTOM) {
            this.setHints(this.hints);
        } else {
            this.setHints(QRTypeConfig.ALL_HINT_MAP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomMultiFormatReader getInstance() {
        if (customMultiFormatReader != null) return customMultiFormatReader;
        Class<CustomMultiFormatReader> clazz = CustomMultiFormatReader.class;
        synchronized (CustomMultiFormatReader.class) {
            if (customMultiFormatReader != null) return customMultiFormatReader;
            customMultiFormatReader = new CustomMultiFormatReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return customMultiFormatReader;
        }
    }

    private CustomMultiFormatReader() {
        this.setType(Config.scanTypeConfig, null);
    }
}

