/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing;

import android.graphics.Rect;
import android.graphics.YuvImage;
import android.os.Environment;
import com.xshare.camera.zxing.core.InvertedLuminanceSource;
import com.xshare.camera.zxing.core.LuminanceSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LightGreySource
extends LuminanceSource {
    private final LuminanceSource delegate;
    static long startTime = System.currentTimeMillis();
    public static int stepX = 2;
    public static int stepY = 2;

    public LightGreySource(LuminanceSource delegate) {
        super(delegate.getWidth(), delegate.getHeight());
        this.delegate = delegate;
    }

    public synchronized void toPut(byte[] nv21, int w, int h) {
        int i;
        if (System.currentTimeMillis() - startTime < 5000L) {
            return;
        }
        startTime = System.currentTimeMillis();
        File file = new File(Environment.getExternalStorageDirectory(), "YUV_\u5904\u7406\u524d.jpg");
        File file0 = new File(Environment.getExternalStorageDirectory(), "YUV_\u5904\u7406\u540e.jpg");
        if (file.exists()) {
            file.delete();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (file0.exists()) {
            file.delete();
            try {
                file0.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] cropNv21 = new byte[nv21.length / 2 * 3];
        for (i = 0; i < w * h; ++i) {
            cropNv21[i] = nv21[i];
        }
        for (i = 0; i < w * h / 2; ++i) {
            if (nv21.length + i >= cropNv21.length) continue;
            cropNv21[nv21.length + i] = -127;
        }
        System.arraycopy(cropNv21, 0, cropNv21, 0, w * h);
        YuvImage yuvImage = new YuvImage(cropNv21, 17, w, h, null);
        try {
            yuvImage.compressToJpeg(new Rect(0, 0, w, h), 100, (OutputStream)new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        int step_h = 0;
        while (step_h + stepX < h) {
            int step_w = 0;
            while (step_w + stepX < w) {
                int x_;
                int y_;
                int count = 0;
                int avage = 0;
                int min = Integer.MAX_VALUE;
                for (y_ = step_h; y_ < step_h + stepY; ++y_) {
                    for (x_ = step_w; x_ < step_w + stepX; ++x_) {
                        if ((cropNv21[y_ * w + x_] & 0xFF) < 130) {
                            ++count;
                        }
                        avage += cropNv21[y_ * w + x_] & 0xFF;
                        if (min <= (cropNv21[y_ * w + x_] & 0xFF)) continue;
                        min = cropNv21[y_ * w + x_] & 0xFF;
                    }
                }
                if (count != 0) {
                    for (y_ = step_h; y_ < step_h + stepY; ++y_) {
                        for (x_ = step_w; x_ < step_w + stepX; ++x_) {
                            cropNv21[y_ * w + x_] = (byte)(min / 3 * 2);
                        }
                    }
                }
                step_w += stepX;
            }
            step_h += stepY;
        }
        YuvImage yuvImage2 = new YuvImage(cropNv21, 17, w, h, null);
        try {
            yuvImage2.compressToJpeg(new Rect(0, 0, w, h), 100, (OutputStream)new FileOutputStream(file0));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] getRow(int y, byte[] row) {
        row = (byte[])this.delegate.getRow(y, row).clone();
        int width = this.getWidth();
        for (int i = 0; i < width; ++i) {
            row[i] = (byte)((float)row[i] * 2.0f);
        }
        return row;
    }

    @Override
    public byte[] getMatrix() {
        return this.delegate.getMatrix();
    }

    @Override
    public boolean isCropSupported() {
        return this.delegate.isCropSupported();
    }

    @Override
    public LuminanceSource crop(int left, int top, int width, int height) {
        return new InvertedLuminanceSource(this.delegate.crop(left, top, width, height));
    }

    @Override
    public boolean isRotateSupported() {
        return this.delegate.isRotateSupported();
    }

    @Override
    public LuminanceSource invert() {
        return this.delegate;
    }

    @Override
    public LuminanceSource rotateCounterClockwise() {
        return new InvertedLuminanceSource(this.delegate.rotateCounterClockwise());
    }

    @Override
    public LuminanceSource rotateCounterClockwise45() {
        return new InvertedLuminanceSource(this.delegate.rotateCounterClockwise45());
    }
}

