/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core;

import com.xshare.camera.zxing.core.BarcodeFormat;
import com.xshare.camera.zxing.core.EncodeHintType;
import com.xshare.camera.zxing.core.Writer;
import com.xshare.camera.zxing.core.WriterException;
import com.xshare.camera.zxing.core.aztec.AztecWriter;
import com.xshare.camera.zxing.core.common.BitMatrix;
import com.xshare.camera.zxing.core.datamatrix.DataMatrixWriter;
import com.xshare.camera.zxing.core.oned.CodaBarWriter;
import com.xshare.camera.zxing.core.oned.Code128Writer;
import com.xshare.camera.zxing.core.oned.Code39Writer;
import com.xshare.camera.zxing.core.oned.Code93Writer;
import com.xshare.camera.zxing.core.oned.EAN13Writer;
import com.xshare.camera.zxing.core.oned.EAN8Writer;
import com.xshare.camera.zxing.core.oned.ITFWriter;
import com.xshare.camera.zxing.core.oned.UPCAWriter;
import com.xshare.camera.zxing.core.oned.UPCEWriter;
import com.xshare.camera.zxing.core.pdf417.PDF417Writer;
import com.xshare.camera.zxing.core.qrcode.QRCodeWriter;
import java.util.Map;

public final class MultiFormatWriter
implements Writer {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        return this.encode(contents, format, width, height, null);
    }

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        Writer writer;
        switch (format) {
            case EAN_8: {
                writer = new EAN8Writer();
                break;
            }
            case UPC_E: {
                writer = new UPCEWriter();
                break;
            }
            case EAN_13: {
                writer = new EAN13Writer();
                break;
            }
            case UPC_A: {
                writer = new UPCAWriter();
                break;
            }
            case QR_CODE: {
                writer = new QRCodeWriter();
                break;
            }
            case CODE_39: {
                writer = new Code39Writer();
                break;
            }
            case CODE_93: {
                writer = new Code93Writer();
                break;
            }
            case CODE_128: {
                writer = new Code128Writer();
                break;
            }
            case ITF: {
                writer = new ITFWriter();
                break;
            }
            case PDF_417: {
                writer = new PDF417Writer();
                break;
            }
            case CODABAR: {
                writer = new CodaBarWriter();
                break;
            }
            case DATA_MATRIX: {
                writer = new DataMatrixWriter();
                break;
            }
            case AZTEC: {
                writer = new AztecWriter();
                break;
            }
            default: {
                throw new IllegalArgumentException("No encoder available for format " + (Object)((Object)format));
            }
        }
        return writer.encode(contents, format, width, height, hints);
    }
}

