/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core;

import android.text.TextUtils;
import com.xshare.camera.zxing.core.Binarizer;
import com.xshare.camera.zxing.core.LuminanceSource;
import com.xshare.camera.zxing.core.PlanarYUVLuminanceSourceRotate;
import com.xshare.camera.zxing.core.common.HybridBinarizer;
import com.xshare.camera.zxing.core.common.HybridBinarizerCrude;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private byte[] matrix;
    private int dataWidth;
    private int dataHeight;
    private int left;
    private int top;
    Binarizer hybridBinary;
    Binarizer hybridBinaryCurde;
    String tagId;

    public PlanarYUVLuminanceSource(byte[] yuvData, int dataWidth, int dataHeight, int left, int top, int width, int height) {
        super(width, height);
        if (left + width > dataWidth || top + height > dataHeight) {
            this.dataHeight = 0;
            this.dataWidth = 0;
            this.left = 0;
            this.top = 0;
            return;
        }
        this.dataWidth = dataWidth;
        this.dataHeight = dataHeight;
        this.left = left;
        this.top = top;
        this.matrix = this.getGlobeMatrix(yuvData);
    }

    public PlanarYUVLuminanceSource(byte[] matrix, int width, int height) {
        super(width, height);
        this.matrix = matrix;
    }

    @Override
    public byte[] getRow(int y, byte[] row) {
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + y);
        }
        int width = this.getWidth();
        if (row == null || row.length < width) {
            row = new byte[width];
        }
        int offset = y * width;
        System.arraycopy(this.matrix, offset, row, 0, width);
        return row;
    }

    public byte[] getGlobeMatrix(byte[] yuvData) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == this.dataWidth && height == this.dataHeight) {
            return yuvData;
        }
        int area = width * height;
        byte[] matrix = new byte[area];
        int inputOffset = this.top * this.dataWidth + this.left;
        try {
            if (width == this.dataWidth) {
                System.arraycopy(yuvData, inputOffset, matrix, 0, area);
                return matrix;
            }
            for (int y = 0; y < height; ++y) {
                int outputOffset = y * width;
                System.arraycopy(yuvData, inputOffset, matrix, outputOffset, width);
                inputOffset += this.dataWidth;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return matrix;
    }

    @Override
    public byte[] getMatrix() {
        return this.matrix;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int left, int top, int width, int height) {
        return this;
    }

    public Binarizer getHybridBinary() {
        if (this.hybridBinary == null) {
            this.hybridBinary = new HybridBinarizer(this);
        }
        return this.hybridBinary;
    }

    public Binarizer getHybridBinaryCurde() {
        if (this.hybridBinaryCurde == null) {
            this.hybridBinaryCurde = new HybridBinarizerCrude(this);
        }
        return this.hybridBinaryCurde;
    }

    public PlanarYUVLuminanceSource copyAll() {
        return new PlanarYUVLuminanceSource((byte[])this.matrix.clone(), this.getWidth(), this.getHeight());
    }

    public PlanarYUVLuminanceSourceRotate onlyCopyWarpRotate() {
        return new PlanarYUVLuminanceSourceRotate(this.matrix, this.getWidth(), this.getHeight());
    }

    public String getTagId() {
        if (TextUtils.isEmpty((CharSequence)this.tagId)) {
            this.tagId = System.currentTimeMillis() + "";
        }
        return this.tagId;
    }
}

