/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core.aztec;

import com.xshare.camera.zxing.core.BarcodeFormat;
import com.xshare.camera.zxing.core.BinaryBitmap;
import com.xshare.camera.zxing.core.DecodeHintType;
import com.xshare.camera.zxing.core.FormatException;
import com.xshare.camera.zxing.core.NotFoundException;
import com.xshare.camera.zxing.core.Reader;
import com.xshare.camera.zxing.core.Result;
import com.xshare.camera.zxing.core.ResultMetadataType;
import com.xshare.camera.zxing.core.ResultPoint;
import com.xshare.camera.zxing.core.ResultPointCallback;
import com.xshare.camera.zxing.core.aztec.AztecDetectorResult;
import com.xshare.camera.zxing.core.aztec.decoder.Decoder;
import com.xshare.camera.zxing.core.aztec.detector.Detector;
import com.xshare.camera.zxing.core.common.DecoderResult;
import java.util.List;
import java.util.Map;

public final class AztecReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        String ecLevel;
        ResultPointCallback rpcb;
        AztecDetectorResult detectorResult;
        NotFoundException notFoundException = null;
        FormatException formatException = null;
        Detector detector = new Detector(image.getBlackMatrix());
        ResultPoint[] points = null;
        DecoderResult decoderResult = null;
        try {
            detectorResult = detector.detect(false);
            points = detectorResult.getPoints();
            decoderResult = new Decoder().decode(detectorResult);
        }
        catch (NotFoundException e) {
            notFoundException = e;
        }
        catch (FormatException e) {
            formatException = e;
        }
        if (decoderResult == null) {
            try {
                detectorResult = detector.detect(true);
                points = detectorResult.getPoints();
                decoderResult = new Decoder().decode(detectorResult);
            }
            catch (FormatException | NotFoundException e) {
                if (notFoundException != null) {
                    throw notFoundException;
                }
                if (formatException != null) {
                    throw formatException;
                }
                throw e;
            }
        }
        if (hints != null && (rpcb = (ResultPointCallback)hints.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            for (ResultPoint point : points) {
                rpcb.foundPossibleResultPoint(point);
            }
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), decoderResult.getNumBits(), points, BarcodeFormat.AZTEC, System.currentTimeMillis());
        List<byte[]> byteSegments = decoderResult.getByteSegments();
        if (byteSegments != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
        }
        if ((ecLevel = decoderResult.getECLevel()) != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        return result;
    }

    @Override
    public void reset() {
    }
}

