/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core.client.result;

import com.xshare.camera.zxing.core.Result;
import com.xshare.camera.zxing.core.client.result.ResultParser;
import com.xshare.camera.zxing.core.client.result.WifiParsedResult;

public final class WifiResultParser
extends ResultParser {
    @Override
    public WifiParsedResult parse(Result result) {
        String rawText = WifiResultParser.getMassagedText(result);
        if (!rawText.startsWith("WIFI:")) {
            return null;
        }
        String ssid = WifiResultParser.matchSinglePrefixedField("S:", rawText = rawText.substring("WIFI:".length()), ';', false);
        if (ssid == null || ssid.isEmpty()) {
            return null;
        }
        String pass = WifiResultParser.matchSinglePrefixedField("P:", rawText, ';', false);
        String type = WifiResultParser.matchSinglePrefixedField("T:", rawText, ';', false);
        if (type == null) {
            type = "nopass";
        }
        boolean hidden = false;
        String phase2Method = WifiResultParser.matchSinglePrefixedField("PH2:", rawText, ';', false);
        String hValue = WifiResultParser.matchSinglePrefixedField("H:", rawText, ';', false);
        if (hValue != null) {
            if (phase2Method != null || "true".equalsIgnoreCase(hValue) || "false".equalsIgnoreCase(hValue)) {
                hidden = Boolean.parseBoolean(hValue);
            } else {
                phase2Method = hValue;
            }
        }
        String identity = WifiResultParser.matchSinglePrefixedField("I:", rawText, ';', false);
        String anonymousIdentity = WifiResultParser.matchSinglePrefixedField("A:", rawText, ';', false);
        String eapMethod = WifiResultParser.matchSinglePrefixedField("E:", rawText, ';', false);
        return new WifiParsedResult(type, ssid, pass, hidden, identity, anonymousIdentity, eapMethod, phase2Method);
    }
}

