/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core.common;

import com.xshare.camera.zxing.core.Binarizer;
import com.xshare.camera.zxing.core.LuminanceSource;
import com.xshare.camera.zxing.core.NotFoundException;
import com.xshare.camera.zxing.core.common.BitMatrix;
import com.xshare.camera.zxing.core.common.GlobalHistogramBinarizer;

public final class HybridBinarizerCrude
extends GlobalHistogramBinarizer {
    private final int BLOCK_SIZE_POWER = HybridBinarizerCrude.getRandom();
    private final int BLOCK_SIZE = 1 << this.BLOCK_SIZE_POWER;
    private final int BLOCK_SIZE_MASK = this.BLOCK_SIZE - 1;
    private final int MINIMUM_DIMENSION = this.BLOCK_SIZE * 5;
    private BitMatrix matrix;

    public HybridBinarizerCrude(LuminanceSource source) {
        super(source);
    }

    private static int getRandom() {
        int max = 7;
        int min = 1;
        int mid = max - min;
        return (int)(Math.random() * (double)(mid + 1)) + min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.bitMatrix == null) {
            HybridBinarizerCrude hybridBinarizerCrude = this;
            synchronized (hybridBinarizerCrude) {
                if (this.bitMatrix == null) {
                    this.bitMatrix = this.creatBitMatrix();
                }
            }
        }
        return this.bitMatrix;
    }

    @Override
    protected BitMatrix creatBitMatrix() throws NotFoundException {
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        int height = source.getHeight();
        if (width >= this.MINIMUM_DIMENSION && height >= this.MINIMUM_DIMENSION) {
            byte[] luminances = source.getMatrix();
            int subWidth = width >> this.BLOCK_SIZE_POWER;
            if ((width & this.BLOCK_SIZE_MASK) != 0) {
                ++subWidth;
            }
            int subHeight = height >> this.BLOCK_SIZE_POWER;
            if ((height & this.BLOCK_SIZE_MASK) != 0) {
                ++subHeight;
            }
            int[][] blackPoints = HybridBinarizerCrude.calculateBlackPoints(luminances, subWidth, subHeight, width, height, this.BLOCK_SIZE, this.BLOCK_SIZE_POWER);
            BitMatrix newMatrix = new BitMatrix(width, height);
            HybridBinarizerCrude.calculateThresholdForBlock(luminances, subWidth, subHeight, width, height, blackPoints, newMatrix, this.BLOCK_SIZE, this.BLOCK_SIZE_POWER);
            this.matrix = newMatrix;
            return this.matrix;
        }
        return null;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource source) {
        return new HybridBinarizerCrude(source);
    }

    private static void calculateThresholdForBlock(byte[] luminances, int subWidth, int subHeight, int width, int height, int[][] blackPoints, BitMatrix matrix, int BLOCK_SIZE, int BLOCK_SIZE_POWER) {
        int maxYOffset = height - BLOCK_SIZE;
        int maxXOffset = width - BLOCK_SIZE;
        for (int y = 0; y < subHeight; ++y) {
            int yoffset = y << BLOCK_SIZE_POWER;
            if (yoffset > maxYOffset) {
                yoffset = maxYOffset;
            }
            int top = HybridBinarizerCrude.cap(y, subHeight - 3);
            for (int x = 0; x < subWidth; ++x) {
                int xoffset = x << BLOCK_SIZE_POWER;
                if (xoffset > maxXOffset) {
                    xoffset = maxXOffset;
                }
                int left = HybridBinarizerCrude.cap(x, subWidth - 3);
                int sum = 0;
                for (int z = -2; z <= 2; ++z) {
                    int[] blackRow = blackPoints[top + z];
                    sum += blackRow[left - 2] + blackRow[left - 1] + blackRow[left] + blackRow[left + 1] + blackRow[left + 2];
                }
                int average = sum / 25;
                HybridBinarizerCrude.thresholdBlock(luminances, xoffset, yoffset, average, width, BLOCK_SIZE, matrix);
            }
        }
    }

    private static int cap(int value, int max) {
        return value < 2 ? 2 : Math.min(value, max);
    }

    private static void thresholdBlock(byte[] luminances, int xoffset, int yoffset, int threshold, int stride, int BLOCK_SIZE, BitMatrix matrix) {
        int y = 0;
        int offset = yoffset * stride + xoffset;
        while (y < BLOCK_SIZE) {
            for (int x = 0; x < BLOCK_SIZE; ++x) {
                if ((luminances[offset + x] & 0xFF) > threshold) continue;
                matrix.set(xoffset + x, yoffset + y);
            }
            ++y;
            offset += stride;
        }
    }

    private static int[][] calculateBlackPoints(byte[] luminances, int subWidth, int subHeight, int width, int height, int BLOCK_SIZE, int BLOCK_SIZE_POWER) {
        int maxYOffset = height - BLOCK_SIZE;
        int maxXOffset = width - BLOCK_SIZE;
        int[][] blackPoints = new int[subHeight][subWidth];
        for (int y = 0; y < subHeight; ++y) {
            int yoffset = y << BLOCK_SIZE_POWER;
            if (yoffset > maxYOffset) {
                yoffset = maxYOffset;
            }
            for (int x = 0; x < subWidth; ++x) {
                int xoffset = x << BLOCK_SIZE_POWER;
                if (xoffset > maxXOffset) {
                    xoffset = maxXOffset;
                }
                int sum = 0;
                int min = 255;
                int max = 0;
                int MIN_DYNAMIC_RANGE = 24;
                int yy = 0;
                int offset = yoffset * width + xoffset;
                while (yy < BLOCK_SIZE) {
                    int xx;
                    for (xx = 0; xx < BLOCK_SIZE; ++xx) {
                        int pixel = luminances[offset + xx] & 0xFF;
                        sum += pixel;
                        if (pixel < min) {
                            min = pixel;
                        }
                        if (pixel <= max) continue;
                        max = pixel;
                    }
                    if (max - min > MIN_DYNAMIC_RANGE) {
                        ++yy;
                        offset += width;
                        while (yy < BLOCK_SIZE) {
                            for (xx = 0; xx < BLOCK_SIZE; ++xx) {
                                sum += luminances[offset + xx] & 0xFF;
                            }
                            ++yy;
                            offset += width;
                        }
                    }
                    ++yy;
                    offset += width;
                }
                int average = sum >> BLOCK_SIZE_POWER * 2;
                if (max - min <= MIN_DYNAMIC_RANGE) {
                    int averageNeighborBlackPoint;
                    average = min / 2;
                    if (y > 0 && x > 0 && min < (averageNeighborBlackPoint = (blackPoints[y - 1][x] + 2 * blackPoints[y][x - 1] + blackPoints[y - 1][x - 1]) / 4)) {
                        average = averageNeighborBlackPoint;
                    }
                }
                blackPoints[y][x] = average;
            }
        }
        return blackPoints;
    }
}

