/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core.datamatrix;

import com.xshare.camera.zxing.core.BarcodeFormat;
import com.xshare.camera.zxing.core.BinaryBitmap;
import com.xshare.camera.zxing.core.ChecksumException;
import com.xshare.camera.zxing.core.DecodeHintType;
import com.xshare.camera.zxing.core.FormatException;
import com.xshare.camera.zxing.core.NotFoundException;
import com.xshare.camera.zxing.core.Reader;
import com.xshare.camera.zxing.core.Result;
import com.xshare.camera.zxing.core.ResultMetadataType;
import com.xshare.camera.zxing.core.ResultPoint;
import com.xshare.camera.zxing.core.common.BitMatrix;
import com.xshare.camera.zxing.core.common.DecoderResult;
import com.xshare.camera.zxing.core.common.DetectorResult;
import com.xshare.camera.zxing.core.datamatrix.decoder.Decoder;
import com.xshare.camera.zxing.core.datamatrix.detector.Detector;
import java.util.List;
import java.util.Map;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, ChecksumException, FormatException {
        String ecLevel;
        ResultPoint[] points;
        DecoderResult decoderResult;
        if (hints != null && hints.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            BitMatrix bits = DataMatrixReader.extractPureBits(image.getBlackMatrix());
            decoderResult = this.decoder.decode(bits);
            points = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(image.getBlackMatrix()).detect();
            decoderResult = this.decoder.decode(detectorResult.getBits());
            points = detectorResult.getPoints();
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.DATA_MATRIX);
        List<byte[]> byteSegments = decoderResult.getByteSegments();
        if (byteSegments != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
        }
        if ((ecLevel = decoderResult.getECLevel()) != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        return result;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix image) throws NotFoundException {
        int[] leftTopBlack = image.getTopLeftOnBit();
        int[] rightBottomBlack = image.getBottomRightOnBit();
        if (leftTopBlack == null || rightBottomBlack == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int moduleSize = DataMatrixReader.moduleSize(leftTopBlack, image);
        int top = leftTopBlack[1];
        int bottom = rightBottomBlack[1];
        int left = leftTopBlack[0];
        int right = rightBottomBlack[0];
        int matrixWidth = (right - left + 1) / moduleSize;
        int matrixHeight = (bottom - top + 1) / moduleSize;
        if (matrixWidth <= 0 || matrixHeight <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int nudge = moduleSize / 2;
        top += nudge;
        left += nudge;
        BitMatrix bits = new BitMatrix(matrixWidth, matrixHeight);
        for (int y = 0; y < matrixHeight; ++y) {
            int iOffset = top + y * moduleSize;
            for (int x = 0; x < matrixWidth; ++x) {
                if (!image.get(left + x * moduleSize, iOffset)) continue;
                bits.set(x, y);
            }
        }
        return bits;
    }

    private static int moduleSize(int[] leftTopBlack, BitMatrix image) throws NotFoundException {
        int x;
        int width = image.getWidth();
        int y = leftTopBlack[1];
        for (x = leftTopBlack[0]; x < width && image.get(x, y); ++x) {
        }
        if (x == width) {
            throw NotFoundException.getNotFoundInstance();
        }
        int moduleSize = x - leftTopBlack[0];
        if (moduleSize == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        return moduleSize;
    }
}

