/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core.datamatrix.decoder;

import com.xshare.camera.zxing.core.ChecksumException;
import com.xshare.camera.zxing.core.FormatException;
import com.xshare.camera.zxing.core.common.BitMatrix;
import com.xshare.camera.zxing.core.common.DecoderResult;
import com.xshare.camera.zxing.core.common.reedsolomon.GenericGF;
import com.xshare.camera.zxing.core.common.reedsolomon.ReedSolomonDecoder;
import com.xshare.camera.zxing.core.common.reedsolomon.ReedSolomonException;
import com.xshare.camera.zxing.core.datamatrix.decoder.BitMatrixParser;
import com.xshare.camera.zxing.core.datamatrix.decoder.DataBlock;
import com.xshare.camera.zxing.core.datamatrix.decoder.DecodedBitStreamParser;
import com.xshare.camera.zxing.core.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    public DecoderResult decode(boolean[][] image) throws FormatException, ChecksumException {
        return this.decode(BitMatrix.parse(image));
    }

    public DecoderResult decode(BitMatrix bits) throws FormatException, ChecksumException {
        BitMatrixParser parser = new BitMatrixParser(bits);
        Version version = parser.getVersion();
        byte[] codewords = parser.readCodewords();
        DataBlock[] dataBlocks = DataBlock.getDataBlocks(codewords, version);
        int totalBytes = 0;
        for (DataBlock db : dataBlocks) {
            totalBytes += db.getNumDataCodewords();
        }
        byte[] resultBytes = new byte[totalBytes];
        for (DataBlock dataBlock : dataBlocks) {
            byte[] codewordBytes = dataBlock.getCodewords();
            int numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            for (int i = 0; i < numDataCodewords; ++i) {
                resultBytes[i * dataBlocksCount + j] = codewordBytes[i];
            }
        }
        return DecodedBitStreamParser.decode(resultBytes);
    }

    private void correctErrors(byte[] codewordBytes, int numDataCodewords) throws ChecksumException {
        int i;
        int numCodewords = codewordBytes.length;
        int[] codewordsInts = new int[numCodewords];
        for (i = 0; i < numCodewords; ++i) {
            codewordsInts[i] = codewordBytes[i] & 0xFF;
        }
        try {
            this.rsDecoder.decode(codewordsInts, codewordBytes.length - numDataCodewords);
        }
        catch (ReedSolomonException ignored) {
            throw ChecksumException.getChecksumInstance();
        }
        for (i = 0; i < numDataCodewords; ++i) {
            codewordBytes[i] = (byte)codewordsInts[i];
        }
    }
}

