/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core.oned;

import com.xshare.camera.zxing.core.BarcodeFormat;
import com.xshare.camera.zxing.core.oned.Code128Reader;
import com.xshare.camera.zxing.core.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.CODE_128);
    }

    @Override
    public boolean[] encode(String contents) {
        int length = contents.length();
        if (length < 1 || length > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + length);
        }
        block17: for (int i = 0; i < length; ++i) {
            char c = contents.charAt(i);
            switch (c) {
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': {
                    continue block17;
                }
                default: {
                    if (c <= '\u007f') continue block17;
                    throw new IllegalArgumentException("Bad character in input: " + c);
                }
            }
        }
        ArrayList<int[]> patterns = new ArrayList<int[]>();
        int checkSum = 0;
        int checkWeight = 1;
        int codeSet = 0;
        int position = 0;
        while (position < length) {
            int patternIndex;
            int newCodeSet = Code128Writer.chooseCode(contents, position, codeSet);
            if (newCodeSet == codeSet) {
                block3 : switch (contents.charAt(position)) {
                    case '\u00f1': {
                        patternIndex = 102;
                        break;
                    }
                    case '\u00f2': {
                        patternIndex = 97;
                        break;
                    }
                    case '\u00f3': {
                        patternIndex = 96;
                        break;
                    }
                    case '\u00f4': {
                        if (codeSet == 101) {
                            patternIndex = 101;
                            break;
                        }
                        patternIndex = 100;
                        break;
                    }
                    default: {
                        switch (codeSet) {
                            case 101: {
                                patternIndex = contents.charAt(position) - 32;
                                if (patternIndex >= 0) break block3;
                                patternIndex += 96;
                                break block3;
                            }
                            case 100: {
                                patternIndex = contents.charAt(position) - 32;
                                break block3;
                            }
                            default: {
                                patternIndex = Integer.parseInt(contents.substring(position, position + 2));
                                ++position;
                            }
                        }
                    }
                }
                ++position;
            } else {
                if (codeSet == 0) {
                    switch (newCodeSet) {
                        case 101: {
                            patternIndex = 103;
                            break;
                        }
                        case 100: {
                            patternIndex = 104;
                            break;
                        }
                        default: {
                            patternIndex = 105;
                            break;
                        }
                    }
                } else {
                    patternIndex = newCodeSet;
                }
                codeSet = newCodeSet;
            }
            patterns.add(Code128Reader.CODE_PATTERNS[patternIndex]);
            checkSum += patternIndex * checkWeight;
            if (position == 0) continue;
            ++checkWeight;
        }
        patterns.add(Code128Reader.CODE_PATTERNS[checkSum %= 103]);
        patterns.add(Code128Reader.CODE_PATTERNS[106]);
        int codeWidth = 0;
        for (int[] pattern : patterns) {
            for (int width : pattern) {
                codeWidth += width;
            }
        }
        boolean[] result = new boolean[codeWidth];
        int pos = 0;
        Object object = patterns.iterator();
        while (object.hasNext()) {
            int[] pattern = (int[])object.next();
            pos += Code128Writer.appendPattern(result, pos, pattern, true);
        }
        return result;
    }

    private static CType findCType(CharSequence value, int start) {
        int last = value.length();
        if (start >= last) {
            return CType.UNCODABLE;
        }
        char c = value.charAt(start);
        if (c == '\u00f1') {
            return CType.FNC_1;
        }
        if (c < '0' || c > '9') {
            return CType.UNCODABLE;
        }
        if (start + 1 >= last) {
            return CType.ONE_DIGIT;
        }
        c = value.charAt(start + 1);
        if (c < '0' || c > '9') {
            return CType.ONE_DIGIT;
        }
        return CType.TWO_DIGITS;
    }

    private static int chooseCode(CharSequence value, int start, int oldCode) {
        CType lookahead = Code128Writer.findCType(value, start);
        if (lookahead == CType.ONE_DIGIT) {
            if (oldCode == 101) {
                return 101;
            }
            return 100;
        }
        if (lookahead == CType.UNCODABLE) {
            char c;
            if (start < value.length() && ((c = value.charAt(start)) < ' ' || oldCode == 101 && (c < '`' || c >= '\u00f1' && c <= '\u00f4'))) {
                return 101;
            }
            return 100;
        }
        if (oldCode == 101 && lookahead == CType.FNC_1) {
            return 101;
        }
        if (oldCode == 99) {
            return 99;
        }
        if (oldCode == 100) {
            if (lookahead == CType.FNC_1) {
                return 100;
            }
            lookahead = Code128Writer.findCType(value, start + 2);
            if (lookahead == CType.UNCODABLE || lookahead == CType.ONE_DIGIT) {
                return 100;
            }
            if (lookahead == CType.FNC_1) {
                lookahead = Code128Writer.findCType(value, start + 3);
                if (lookahead == CType.TWO_DIGITS) {
                    return 99;
                }
                return 100;
            }
            int index = start + 4;
            while ((lookahead = Code128Writer.findCType(value, index)) == CType.TWO_DIGITS) {
                index += 2;
            }
            if (lookahead == CType.ONE_DIGIT) {
                return 100;
            }
            return 99;
        }
        if (lookahead == CType.FNC_1) {
            lookahead = Code128Writer.findCType(value, start + 1);
        }
        if (lookahead == CType.TWO_DIGITS) {
            return 99;
        }
        return 100;
    }

    private static enum CType {
        UNCODABLE,
        ONE_DIGIT,
        TWO_DIGITS,
        FNC_1;

    }
}

