/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera.zxing.core.qrcode.detector;

import com.xshare.camera.zxing.core.ResultPoint;

public final class FinderPattern
extends ResultPoint {
    private final float estimatedModuleSize;
    private final int count;

    FinderPattern(float posX, float posY, float estimatedModuleSize) {
        this(posX, posY, estimatedModuleSize, 1);
    }

    private FinderPattern(float posX, float posY, float estimatedModuleSize, int count) {
        super(posX, posY);
        this.estimatedModuleSize = estimatedModuleSize;
        this.count = count;
    }

    public float getEstimatedModuleSize() {
        return this.estimatedModuleSize;
    }

    int getCount() {
        return this.count;
    }

    boolean aboutEquals(float moduleSize, float i, float j) {
        if (Math.abs(i - this.getY()) <= moduleSize && Math.abs(j - this.getX()) <= moduleSize) {
            float moduleSizeDiff = Math.abs(moduleSize - this.estimatedModuleSize);
            return moduleSizeDiff <= 1.0f || moduleSizeDiff <= this.estimatedModuleSize;
        }
        return false;
    }

    FinderPattern combineEstimate(float i, float j, float newModuleSize) {
        int combinedCount = this.count + 1;
        float combinedX = ((float)this.count * this.getX() + j) / (float)combinedCount;
        float combinedY = ((float)this.count * this.getY() + i) / (float)combinedCount;
        float combinedModuleSize = ((float)this.count * this.estimatedModuleSize + newModuleSize) / (float)combinedCount;
        return new FinderPattern(combinedX, combinedY, combinedModuleSize, combinedCount);
    }
}

