/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.permissions;

import android.app.Activity;
import android.app.AlarmManager;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.RequiresApi;
import com.xshare.permissions.PermissionDelegateImplV30;
import com.xshare.permissions.PermissionUtils;

@RequiresApi(api=31)
class PermissionDelegateImplV31
extends PermissionDelegateImplV30 {
    PermissionDelegateImplV31() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return PermissionDelegateImplV31.isGrantedAlarmPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE")) {
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isPermissionPermanentDenied(Activity activity, String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE")) {
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (activity.getApplicationInfo().targetSdkVersion >= 31 && PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (!PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_COARSE_LOCATION")) {
                return !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_COARSE_LOCATION");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        return super.isPermissionPermanentDenied(activity, permission2);
    }

    @Override
    public Intent getPermissionIntent(Context context, String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return PermissionDelegateImplV31.getAlarmPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    private static boolean isGrantedAlarmPermission(Context context) {
        return ((AlarmManager)context.getSystemService(AlarmManager.class)).canScheduleExactAlarms();
    }

    private static Intent getAlarmPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

