/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.room;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.xshare.base.util.DLog;
import com.xshare.room.dao.ReceiveInfoDao;
import com.xshare.room.dao.SendDao;
import com.xshare.room.entity.ReceiveInfoEntity;
import com.xshare.room.entity.SendInfoEntity;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH&J\n\u0010\f\u001a\u0004\u0018\u00010\rH&J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/xshare/room/AppDatabase;", "Landroidx/room/RoomDatabase;", "()V", "databaseCreated", "Landroidx/lifecycle/LiveData;", "", "getDatabaseCreated", "()Landroidx/lifecycle/LiveData;", "mIsDatabaseCreated", "Landroidx/lifecycle/MutableLiveData;", "recordInfoDao", "Lcom/xshare/room/dao/ReceiveInfoDao;", "sendDao", "Lcom/xshare/room/dao/SendDao;", "setDatabaseCreated", "", "updateDatabaseCreated", "context", "Landroid/content/Context;", "Companion", "app_release"})
@Database(entities={SendInfoEntity.class, ReceiveInfoEntity.class}, version=1, exportSchema=false)
public abstract class AppDatabase
extends RoomDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableLiveData<Boolean> mIsDatabaseCreated = new MutableLiveData();
    public static final int VERSION_SUPPORT_SDK_DATA = 1;
    public static final int CURRENT_VERSION = 1;
    @Nullable
    private static AppDatabase sInstance;
    @NotNull
    private static final String DATABASE_NAME;
    @Nullable
    private static WeakReference<Context> mContext;
    @NotNull
    private static final Migration MIGRATION_0_1;

    @Nullable
    public abstract SendDao sendDao();

    @Nullable
    public abstract ReceiveInfoDao recordInfoDao();

    private final void updateDatabaseCreated(Context context) {
        if (context.getDatabasePath(DATABASE_NAME).exists()) {
            this.setDatabaseCreated();
        }
    }

    private final void setDatabaseCreated() {
        this.mIsDatabaseCreated.postValue((Object)true);
    }

    @NotNull
    public final LiveData<Boolean> getDatabaseCreated() {
        return (LiveData)this.mIsDatabaseCreated;
    }

    @JvmStatic
    @Nullable
    public static final AppDatabase getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public static final /* synthetic */ void access$setDatabaseCreated(AppDatabase $this) {
        $this.setDatabaseCreated();
    }

    static {
        DATABASE_NAME = "xshare-sdk-db";
        MIGRATION_0_1 = new Migration(){

            public void migrate(@NotNull SupportSQLiteDatabase database) {
                Intrinsics.checkNotNullParameter((Object)database, (String)"database");
                DLog.INSTANCE.d("Migration", "1");
            }
        };
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/xshare/room/AppDatabase$Companion;", "", "()V", "CURRENT_VERSION", "", "DATABASE_NAME", "", "getDATABASE_NAME$annotations", "getDATABASE_NAME", "()Ljava/lang/String;", "MIGRATION_0_1", "Landroidx/room/migration/Migration;", "VERSION_SUPPORT_SDK_DATA", "mContext", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "sInstance", "Lcom/xshare/room/AppDatabase;", "buildDatabase", "appContext", "execSQL", "", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "sqlStr", "getInstance", "context", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDATABASE_NAME() {
            return DATABASE_NAME;
        }

        @VisibleForTesting
        public static /* synthetic */ void getDATABASE_NAME$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final AppDatabase getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (sInstance == null) {
                Class<AppDatabase> clazz = AppDatabase.class;
                synchronized (clazz) {
                    boolean bl = false;
                    if (sInstance == null) {
                        mContext = new WeakReference<Context>(context.getApplicationContext());
                        Context context2 = context.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
                        sInstance = Companion.buildDatabase(context2);
                        AppDatabase appDatabase = sInstance;
                        if (appDatabase != null) {
                            Context context3 = context.getApplicationContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context.applicationContext");
                            appDatabase.updateDatabaseCreated(context3);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return sInstance;
        }

        private final AppDatabase buildDatabase(Context appContext) {
            Migration[] migrationArray = new Migration[]{MIGRATION_0_1};
            RoomDatabase roomDatabase = Room.databaseBuilder((Context)appContext, AppDatabase.class, (String)this.getDATABASE_NAME()).setJournalMode(RoomDatabase.JournalMode.TRUNCATE).addCallback(new RoomDatabase.Callback(){

                public void onCreate(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    try {
                        super.onCreate(db);
                    }
                    catch (Exception e) {
                        DLog.INSTANCE.e("XSLOG", Intrinsics.stringPlus((String)"buildDatabase: onCreate err ", (Object)e.getMessage()));
                    }
                    if (AppDatabase.access$getSInstance$cp() != null) {
                        AppDatabase appDatabase = AppDatabase.access$getSInstance$cp();
                        if (appDatabase != null) {
                            AppDatabase.access$setDatabaseCreated(appDatabase);
                        }
                    }
                }

                public void onOpen(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    try {
                        super.onOpen(db);
                    }
                    catch (Exception e) {
                        DLog.INSTANCE.e("XSLOG", Intrinsics.stringPlus((String)"buildDatabase: onOpen err ", (Object)e.getMessage()));
                    }
                }
            }).fallbackToDestructiveMigration().addMigrations(migrationArray).build();
            Intrinsics.checkNotNullExpressionValue((Object)roomDatabase, (String)"databaseBuilder<AppDatab\u2026ns(MIGRATION_0_1).build()");
            return (AppDatabase)roomDatabase;
        }

        private final void execSQL(SupportSQLiteDatabase database, String sqlStr) {
            if (database == null) {
                return;
            }
            try {
                database.execSQL(sqlStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                DLog.INSTANCE.e("mare", Intrinsics.stringPlus((String)"execSQL: err ", (Object)e.getMessage()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

