/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.room.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.xshare.room.dao.SendDao;
import com.xshare.room.entity.SendInfoEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class SendDao_Impl
implements SendDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SendInfoEntity> __insertionAdapterOfSendInfoEntity;
    private final EntityDeletionOrUpdateAdapter<SendInfoEntity> __updateAdapterOfSendInfoEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdate;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllUI;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllAppBundleChild;

    public SendDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSendInfoEntity = new EntityInsertionAdapter<SendInfoEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `SendEntity` (`id`,`fileName`,`fileMD5`,`isFolder`,`fileSize`,`progress`,`sourcePath`,`mimeType`,`savePath`,`transFileType`,`transferredSize`,`parentId`,`gaid`,`modifyTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SendInfoEntity value) {
                stmt.bindLong(1, value.getId());
                if (value.getFileName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFileName());
                }
                if (value.getFileMD5() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFileMD5());
                }
                int _tmp = value.isFolder() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                stmt.bindLong(5, value.getFileSize());
                stmt.bindLong(6, (long)value.getProgress());
                if (value.getSourcePath() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getSourcePath());
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMimeType());
                }
                if (value.getSavePath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getSavePath());
                }
                stmt.bindLong(10, (long)value.getTransFileType());
                stmt.bindLong(11, value.getTransferredSize());
                stmt.bindLong(12, value.getParentId());
                if (value.getGaid() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getGaid());
                }
                stmt.bindLong(14, value.getModifyTime());
            }
        };
        this.__updateAdapterOfSendInfoEntity = new EntityDeletionOrUpdateAdapter<SendInfoEntity>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `SendEntity` SET `id` = ?,`fileName` = ?,`fileMD5` = ?,`isFolder` = ?,`fileSize` = ?,`progress` = ?,`sourcePath` = ?,`mimeType` = ?,`savePath` = ?,`transFileType` = ?,`transferredSize` = ?,`parentId` = ?,`gaid` = ?,`modifyTime` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SendInfoEntity value) {
                stmt.bindLong(1, value.getId());
                if (value.getFileName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFileName());
                }
                if (value.getFileMD5() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFileMD5());
                }
                int _tmp = value.isFolder() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                stmt.bindLong(5, value.getFileSize());
                stmt.bindLong(6, (long)value.getProgress());
                if (value.getSourcePath() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getSourcePath());
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMimeType());
                }
                if (value.getSavePath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getSavePath());
                }
                stmt.bindLong(10, (long)value.getTransFileType());
                stmt.bindLong(11, value.getTransferredSize());
                stmt.bindLong(12, value.getParentId());
                if (value.getGaid() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getGaid());
                }
                stmt.bindLong(14, value.getModifyTime());
                stmt.bindLong(15, value.getId());
            }
        };
        this.__preparedStmtOfUpdate = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update SendEntity set parentId = ? where id = ?";
                return "update SendEntity set parentId = ? where id = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from SendEntity";
                return "delete from SendEntity";
            }
        };
        this.__preparedStmtOfDeleteAllUI = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from SendEntity where (transFileType = 1 or transFileType = 2)";
                return "delete from SendEntity where (transFileType = 1 or transFileType = 2)";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from SendEntity where id = ?";
                return "delete from SendEntity where id = ?";
            }
        };
        this.__preparedStmtOfDeleteAllAppBundleChild = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from SendEntity where transFileType = 4";
                return "delete from SendEntity where transFileType = 4";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(SendInfoEntity entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfSendInfoEntity.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<SendInfoEntity> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSendInfoEntity.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(SendInfoEntity entity) {
        this.__db.assertNotSuspendingTransaction();
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__updateAdapterOfSendInfoEntity.handle((Object)entity);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(List<SendInfoEntity> entityList) {
        this.__db.assertNotSuspendingTransaction();
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__updateAdapterOfSendInfoEntity.handleMultiple(entityList);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(long id2, long parentId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdate.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, parentId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, id2);
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdate.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAllUI() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllUI.acquire();
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllUI.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteById(long id2) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, id2);
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAllAppBundleChild() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllAppBundleChild.acquire();
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllAppBundleChild.release(_stmt);
        }
    }

    @Override
    public LiveData<SendInfoEntity> loadSendEntityLiveData(long id2) {
        String _sql = "select * from SendEntity where id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id2);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"SendEntity"}, false, (Callable)new Callable<SendInfoEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SendInfoEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SendDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    SendInfoEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
                    int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
                    int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
                    int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
                    int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
                    int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
                    int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
                    if (_cursor.moveToFirst()) {
                        _result = new SendInfoEntity();
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result.setId(_tmpId);
                        String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                        _result.setFileName(_tmpFileName);
                        String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                        _result.setFileMD5(_tmpFileMD5);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                        boolean _tmpIsFolder = _tmp != 0;
                        _result.setFolder(_tmpIsFolder);
                        long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                        _result.setFileSize(_tmpFileSize);
                        int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                        _result.setProgress(_tmpProgress);
                        String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                        _result.setSourcePath(_tmpSourcePath);
                        String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                        _result.setMimeType(_tmpMimeType);
                        String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                        _result.setSavePath(_tmpSavePath);
                        int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                        _result.setTransFileType(_tmpTransFileType);
                        long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                        _result.setTransferredSize(_tmpTransferredSize);
                        long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                        _result.setGaid(_tmpGaid);
                        long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                        _result.setModifyTime(_tmpModifyTime);
                    } else {
                        _result = null;
                    }
                    SendInfoEntity sendInfoEntity = _result;
                    return sendInfoEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryAllTotalSize() {
        String _sql = "select sum(fileSize) from SendEntity where parentId = 0 and (transFileType = 1 or transFileType = 2 or transFileType = 0)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select sum(fileSize) from SendEntity where parentId = 0 and (transFileType = 1 or transFileType = 2 or transFileType = 0)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            long _result = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<Long> queryFolderDownloadTotalSizeLiveData() {
        String _sql = "select sum(transferredSize) from SendEntity where parentId = 0 and (transFileType = 1 or transFileType = 2)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select sum(transferredSize) from SendEntity where parentId = 0 and (transFileType = 1 or transFileType = 2)", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"SendEntity"}, false, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SendDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Long _result;
                    if (_cursor.moveToFirst()) {
                        Long _tmp = _cursor.isNull(0) ? null : Long.valueOf(_cursor.getLong(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Long l = _result;
                    return l;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<Long> queryFileDownloadTotalSizeLiveData() {
        String _sql = "select sum(transferredSize) from SendEntity where parentId = 0 and transFileType = 0";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select sum(transferredSize) from SendEntity where parentId = 0 and transFileType = 0", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"SendEntity"}, false, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SendDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Long _result;
                    if (_cursor.moveToFirst()) {
                        Long _tmp = _cursor.isNull(0) ? null : Long.valueOf(_cursor.getLong(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Long l = _result;
                    return l;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendInfoEntity> queryAllFileList() {
        String _sql = "select * from SendEntity where (transFileType = 0 or transFileType = 3 or transFileType = 4)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where (transFileType = 0 or transFileType = 3 or transFileType = 4)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            ArrayList<SendInfoEntity> _result = new ArrayList<SendInfoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                SendInfoEntity _item = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _item.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _item.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _item.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _item.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _item.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _item.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _item.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _item.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _item.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _item.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _item.setModifyTime(_tmpModifyTime);
                _result.add(_item);
            }
            ArrayList<SendInfoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendInfoEntity> queryPrepareAllItemList() {
        String _sql = "select * from SendEntity where  (transFileType = 1 or transFileType = 2 or transFileType = 0)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where  (transFileType = 1 or transFileType = 2 or transFileType = 0)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            ArrayList<SendInfoEntity> _result = new ArrayList<SendInfoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                SendInfoEntity _item = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _item.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _item.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _item.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _item.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _item.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _item.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _item.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _item.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _item.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _item.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _item.setModifyTime(_tmpModifyTime);
                _result.add(_item);
            }
            ArrayList<SendInfoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendInfoEntity> queryPrepareAllChildList() {
        String _sql = "select * from SendEntity where  (transFileType = 4 or transFileType = 3)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where  (transFileType = 4 or transFileType = 3)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            ArrayList<SendInfoEntity> _result = new ArrayList<SendInfoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                SendInfoEntity _item = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _item.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _item.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _item.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _item.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _item.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _item.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _item.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _item.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _item.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _item.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _item.setModifyTime(_tmpModifyTime);
                _result.add(_item);
            }
            ArrayList<SendInfoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendInfoEntity> queryPrepareItemList(int pageCount, int pageIndex) {
        String _sql = "select * from SendEntity where (transFileType = 1 or transFileType = 2 or transFileType = 0) order by id asc limit ? offset ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where (transFileType = 1 or transFileType = 2 or transFileType = 0) order by id asc limit ? offset ? ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)pageCount);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)pageIndex);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            ArrayList<SendInfoEntity> _result = new ArrayList<SendInfoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                SendInfoEntity _item = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _item.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _item.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _item.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _item.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _item.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _item.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _item.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _item.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _item.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _item.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _item.setModifyTime(_tmpModifyTime);
                _result.add(_item);
            }
            ArrayList<SendInfoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendInfoEntity> queryPrepareChildList(int pageCount, int pageIndex) {
        String _sql = "select * from SendEntity where  (transFileType = 3 or transFileType = 4) order by id asc limit ? offset ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where  (transFileType = 3 or transFileType = 4) order by id asc limit ? offset ? ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)pageCount);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)pageIndex);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            ArrayList<SendInfoEntity> _result = new ArrayList<SendInfoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                SendInfoEntity _item = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _item.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _item.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _item.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _item.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _item.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _item.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _item.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _item.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _item.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _item.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _item.setModifyTime(_tmpModifyTime);
                _result.add(_item);
            }
            ArrayList<SendInfoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryPrepareAllItemListCount() {
        String _sql = "select count(id) from SendEntity where  (transFileType = 1 or transFileType = 2 or transFileType = 0)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select count(id) from SendEntity where  (transFileType = 1 or transFileType = 2 or transFileType = 0)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryPrepareAllCount() {
        String _sql = "select count(id) from SendEntity";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select count(id) from SendEntity", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryPrepareAllTotalSize() {
        String _sql = "select sum(fileSize) from SendEntity where parentId = 0 and (transFileType = 1 or transFileType = 2 or transFileType = 0)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select sum(fileSize) from SendEntity where parentId = 0 and (transFileType = 1 or transFileType = 2 or transFileType = 0)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            long _result = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendInfoEntity> queryPrepareAppItemList() {
        String _sql = "select * from SendEntity where  (transFileType = 1 or transFileType = 2 or transFileType = 0)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where  (transFileType = 1 or transFileType = 2 or transFileType = 0)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            ArrayList<SendInfoEntity> _result = new ArrayList<SendInfoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                SendInfoEntity _item = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _item.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _item.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _item.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _item.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _item.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _item.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _item.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _item.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _item.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _item.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _item.setModifyTime(_tmpModifyTime);
                _result.add(_item);
            }
            ArrayList<SendInfoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendInfoEntity queryUnconfirmedPrepareChildEntity() {
        String _sql = "select * from SendEntity where  (transFileType = 4 or transFileType = 3)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where  (transFileType = 4 or transFileType = 3)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            SendInfoEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            if (_cursor.moveToFirst()) {
                _result = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _result.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _result.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _result.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _result.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _result.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _result.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _result.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _result.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _result.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _result.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _result.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _result.setModifyTime(_tmpModifyTime);
            } else {
                _result = null;
            }
            SendInfoEntity sendInfoEntity = _result;
            return sendInfoEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendInfoEntity queryPrepareEntity(long id2) {
        String _sql = "select * from SendEntity where id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id2);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            SendInfoEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            if (_cursor.moveToFirst()) {
                _result = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _result.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _result.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _result.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _result.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _result.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _result.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _result.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _result.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _result.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _result.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _result.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _result.setModifyTime(_tmpModifyTime);
            } else {
                _result = null;
            }
            SendInfoEntity sendInfoEntity = _result;
            return sendInfoEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendInfoEntity querySendFileFromName(String fileName) {
        String _sql = "select * from SendEntity where fileName=? and progress != 100";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where fileName=? and progress != 100", (int)1);
        int _argIndex = 1;
        if (fileName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, fileName);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            SendInfoEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            if (_cursor.moveToFirst()) {
                _result = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _result.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _result.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _result.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _result.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _result.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _result.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _result.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _result.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _result.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _result.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _result.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _result.setModifyTime(_tmpModifyTime);
            } else {
                _result = null;
            }
            SendInfoEntity sendInfoEntity = _result;
            return sendInfoEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendInfoEntity> querySendFileSuccessData() {
        String _sql = "select * from SendEntity where progress = 100";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from SendEntity where progress = 100", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileName");
            int _cursorIndexOfFileMD5 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileMD5");
            int _cursorIndexOfIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isFolder");
            int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
            int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"progress");
            int _cursorIndexOfSourcePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcePath");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfSavePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"savePath");
            int _cursorIndexOfTransFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transFileType");
            int _cursorIndexOfTransferredSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferredSize");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfGaid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gaid");
            int _cursorIndexOfModifyTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"modifyTime");
            ArrayList<SendInfoEntity> _result = new ArrayList<SendInfoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                SendInfoEntity _item = new SendInfoEntity();
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpFileName = _cursor.getString(_cursorIndexOfFileName);
                _item.setFileName(_tmpFileName);
                String _tmpFileMD5 = _cursor.getString(_cursorIndexOfFileMD5);
                _item.setFileMD5(_tmpFileMD5);
                int _tmp = _cursor.getInt(_cursorIndexOfIsFolder);
                boolean _tmpIsFolder = _tmp != 0;
                _item.setFolder(_tmpIsFolder);
                long _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
                _item.setFileSize(_tmpFileSize);
                int _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
                _item.setProgress(_tmpProgress);
                String _tmpSourcePath = _cursor.getString(_cursorIndexOfSourcePath);
                _item.setSourcePath(_tmpSourcePath);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _item.setSavePath(_tmpSavePath);
                int _tmpTransFileType = _cursor.getInt(_cursorIndexOfTransFileType);
                _item.setTransFileType(_tmpTransFileType);
                long _tmpTransferredSize = _cursor.getLong(_cursorIndexOfTransferredSize);
                _item.setTransferredSize(_tmpTransferredSize);
                long _tmpParentId = _cursor.getLong(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpGaid = _cursor.getString(_cursorIndexOfGaid);
                _item.setGaid(_tmpGaid);
                long _tmpModifyTime = _cursor.getLong(_cursorIndexOfModifyTime);
                _item.setModifyTime(_tmpModifyTime);
                _result.add(_item);
            }
            ArrayList<SendInfoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Long[] ids) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("delete from SendEntity where id IN (");
        int _inputSize = ids.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (Long _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindLong(_argIndex, _item.longValue());
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

