/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xshare.base.net.util.GsonUtils;
import com.xshare.base.util.DLog;
import com.xshare.business.utils.CommonConstants;
import com.xshare.business.utils.MD5Utils;
import com.xshare.room.impl.RoomServiceImpl;
import com.xshare.trans.R;
import com.xshare.webserver.ClientOperationActivity;
import com.xshare.webserver.FileDataManager;
import com.xshare.webserver.TransferInterfaceManager;
import com.xshare.webserver.WebServerManager;
import com.xshare.webserver.adapter.FileListAdapter;
import com.xshare.webserver.bean.FileInfoBean;
import com.xshare.webserver.bean.MessageBean;
import com.xshare.webserver.http.ApiService;
import com.xshare.webserver.http.RetrofitCommonManager;
import com.xshare.webserver.utils.Constants;
import com.xshare.webserver.utils.FileUtils;
import com.yanzhenjie.andserver.bean.ProgressBean;
import com.yanzhenjie.andserver.util.IOUtils;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\nH\u0014J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\b\u0010\u001a\u001a\u00020\nH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/xshare/webserver/ClientOperationActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "setRecyclerView", "(Landroidx/recyclerview/widget/RecyclerView;)V", "checkPermission", "", "getLocalIP", "", "initData", "initView", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "openFileManager", "sendMoreFile", "app_release"})
public final class ClientOperationActivity
extends AppCompatActivity {
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();
    @Nullable
    private RecyclerView recyclerView;

    @Nullable
    public final RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public final void setRecyclerView(@Nullable RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_client_operation);
        this.checkPermission();
        this.initView();
        this.initData();
    }

    private final void initData() {
        TransferInterfaceManager.INSTANCE.heartbeatMessage(new MessageBean(200, 324001L, "", false, ""));
        TransferInterfaceManager.INSTANCE.getMessage();
        WebServerManager.INSTANCE.startWebServer((Context)this, 8866);
        WebServerManager.INSTANCE.isSucceed().observe((LifecycleOwner)this, arg_0 -> ClientOperationActivity.initData$lambda-1(this, arg_0));
        TransferInterfaceManager.INSTANCE.heartbeatMessage(new MessageBean(202, 324001L, "", false, ""));
    }

    private final String getLocalIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en != null && en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr != null && enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String string2 = inetAddress.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inetAddress.hostAddress");
                    if (!StringsKt.startsWith$default((String)string2, (String)"192.168", (boolean)false, (int)2, null)) continue;
                    Log.d((String)"WifiHotCreate", (String)Intrinsics.stringPlus((String)"inetAddress ==", (Object)inetAddress.getHostAddress()));
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)"WifiHotCreate", (String)Intrinsics.stringPlus((String)"Can't getIP SocketException:", (Object)ex));
        }
        return null;
    }

    private final void initView() {
        ((Button)this.findViewById(R.id.bt_success)).setOnClickListener(ClientOperationActivity::initView$lambda-2);
        ((Button)this.findViewById(R.id.bt_continuation)).setOnClickListener(arg_0 -> ClientOperationActivity.initView$lambda-3(this, arg_0));
        ((Button)this.findViewById(R.id.bt_disconnect)).setOnClickListener(ClientOperationActivity::initView$lambda-4);
        ((Button)this.findViewById(R.id.bt_send_more)).setOnClickListener(arg_0 -> ClientOperationActivity.initView$lambda-5(this, arg_0));
        RecyclerView recyclerView = this.recyclerView = (RecyclerView)this.findViewById(R.id.list_file);
        if (recyclerView != null) {
            RecyclerView recyclerView2;
            RecyclerView $this$initView_u24lambda_u2d6 = recyclerView2 = recyclerView;
            boolean bl = false;
            $this$initView_u24lambda_u2d6.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
            $this$initView_u24lambda_u2d6.setAdapter((RecyclerView.Adapter)new FileListAdapter((Context)this, (List<FileInfoBean>)FileDataManager.INSTANCE.getReceiveFileData()));
        }
        FileDataManager.INSTANCE.getReceiveDataUpdate().observe((LifecycleOwner)this, arg_0 -> ClientOperationActivity.initView$lambda-7(this, arg_0));
        IOUtils.progress.observe((LifecycleOwner)this, ClientOperationActivity::initView$lambda-8);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private final void openFileManager(int requestCode) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        this.startActivityForResult(intent, requestCode);
    }

    private final void checkPermission() {
        if (Build.VERSION.SDK_INT <= 29) {
            int i = ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (i != 0) {
                String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.ACCESS_FINE_LOCATION"};
                ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])stringArray, (int)100);
            }
        } else if (!Environment.isExternalStorageManager()) {
            Intent intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
            intent.setData(Uri.parse((String)Intrinsics.stringPlus((String)"package:", (Object)this.getPackageName())));
            this.startActivityForResult(intent, 1003);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        String path;
        Uri it;
        Uri uri;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001 && resultCode == -1) {
            Intent intent = data;
            Uri uri2 = uri = intent == null ? null : intent.getData();
            if (uri2 != null) {
                String string2;
                it = uri2;
                boolean bl = false;
                FileUtils fileUtils = FileUtils.Companion.getInstance((Context)this);
                path = fileUtils == null ? null : fileUtils.getChooseFileResultPath(it);
                Toast.makeText((Context)((Context)this), (CharSequence)path, (int)1).show();
                FileInfoBean fileInfoBean = new FileInfoBean();
                String string3 = path;
                if (string3 == null) {
                    string2 = null;
                } else {
                    String string4 = string3.substring(StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                }
                fileInfoBean.setFileName(string2);
                fileInfoBean.setFilePath(path);
                fileInfoBean.setFileMD5(MD5Utils.getFileMD5(path));
                fileInfoBean.setGaid(CommonConstants.INSTANCE.getGAID());
                FileDataManager.INSTANCE.getReceiveFileData().add(fileInfoBean);
                RecyclerView recyclerView = this.getRecyclerView();
                if (recyclerView != null) {
                    RecyclerView.Adapter adapter = recyclerView.getAdapter();
                    if (adapter != null) {
                        adapter.notifyDataSetChanged();
                    }
                }
            }
        }
        if (requestCode == 1002 && resultCode == -1) {
            Intent intent = data;
            Uri uri3 = uri = intent == null ? null : intent.getData();
            if (uri3 != null) {
                String string5;
                it = uri3;
                boolean bl = false;
                FileDataManager.INSTANCE.getSendMoreFiles().clear();
                FileUtils fileUtils = FileUtils.Companion.getInstance((Context)this);
                path = fileUtils == null ? null : fileUtils.getChooseFileResultPath(it);
                String fileMD5 = MD5Utils.getFileMD5(path);
                Toast.makeText((Context)((Context)this), (CharSequence)path, (int)1).show();
                FileInfoBean fileInfoBean = new FileInfoBean();
                fileInfoBean.setServer(true);
                String string6 = path;
                if (string6 == null) {
                    string5 = null;
                } else {
                    String string7 = string6.substring(StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
                    string5 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                }
                fileInfoBean.setFileName(string5);
                fileInfoBean.setFilePath(path);
                fileInfoBean.setFileMD5(fileMD5);
                fileInfoBean.setGaid(CommonConstants.INSTANCE.getGAID());
                fileInfoBean.setSize(new File(path).length());
                FileDataManager.INSTANCE.getSendMoreFiles().add(fileInfoBean);
                FileDataManager.INSTANCE.getReceiveFileData().add(fileInfoBean);
                RecyclerView recyclerView = this.getRecyclerView();
                if (recyclerView != null) {
                    RecyclerView.Adapter adapter = recyclerView.getAdapter();
                    if (adapter != null) {
                        adapter.notifyDataSetChanged();
                    }
                }
                this.sendMoreFile();
            }
        }
    }

    private final void sendMoreFile() {
        String string2 = Constants.INSTANCE.getBaseUrl();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            RetrofitCommonManager.Companion.getInstance().getApiService(ApiService.class, it).sendMoreFile(GsonUtils.toJson(FileDataManager.INSTANCE.getSendMoreFiles()), false).subscribeOn(Schedulers.io()).subscribe(ClientOperationActivity::sendMoreFile$lambda-13$lambda-11, ClientOperationActivity::sendMoreFile$lambda-13$lambda-12);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        FileDataManager.INSTANCE.getSendFileData().clear();
        FileDataManager.INSTANCE.getReceiveFileData().clear();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 == null) {
                view = null;
            } else {
                map.put(id2, view2);
                view = view2;
            }
        }
        return view;
    }

    private static final void initData$lambda-1(ClientOperationActivity this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Integer n = it;
        int n2 = 1;
        if (n != null && n == n2) {
            String string2 = this$0.getLocalIP();
            if (string2 != null) {
                String ip = string2;
                boolean bl = false;
                String clientBaseUrl = "http://" + ip + ":8866";
                MessageBean messageBean = new MessageBean(298, 324001L, "", false, clientBaseUrl);
                TransferInterfaceManager.INSTANCE.heartbeatMessage(messageBean);
            }
        } else {
            Integer n3 = it;
            n2 = 0;
            if (n3 != null && n3 == 0) {
                Toast.makeText((Context)((Context)this$0), (CharSequence)"\u94fe\u63a5\u5df2\u65ad\u5f00", (int)0).show();
                this$0.finish();
            }
        }
    }

    private static final void initView$lambda-2(View it) {
        RoomServiceImpl.INSTANCE.querySendFileSuccessData((Function1<? super List<FileInfoBean>, Unit>)((Function1)initView.1.1.INSTANCE));
        RoomServiceImpl.INSTANCE.queryReceiveFileSuccessData((Function1<? super List<FileInfoBean>, Unit>)((Function1)initView.1.2.INSTANCE));
    }

    private static final void initView$lambda-3(ClientOperationActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        RoomServiceImpl.INSTANCE.queryReceiveFileData((Function1<? super List<FileInfoBean>, Unit>)((Function1)new Function1<List<FileInfoBean>, Unit>(this$0){
            final /* synthetic */ ClientOperationActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<FileInfoBean> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                DLog.INSTANCE.e("XSLOG", Intrinsics.stringPlus((String)"bt_continuation it=", it));
                if (!((Collection)it).isEmpty()) {
                    this.this$0.runOnUiThread(() -> initView.2.1.invoke$lambda-0(it, this.this$0));
                    TransferInterfaceManager.INSTANCE.fileDownload(it);
                }
            }

            private static final void invoke$lambda-0(List $it, ClientOperationActivity this$0) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                FileDataManager.INSTANCE.getReceiveFileData().addAll($it);
                RecyclerView recyclerView = this$0.getRecyclerView();
                if (recyclerView != null) {
                    RecyclerView.Adapter adapter = recyclerView.getAdapter();
                    if (adapter != null) {
                        adapter.notifyDataSetChanged();
                    }
                }
            }
        }));
    }

    private static final void initView$lambda-4(View it) {
        TransferInterfaceManager.INSTANCE.heartbeatMessage(new MessageBean(201, 324001L, "", false, ""));
        WebServerManager.INSTANCE.shutdownServer();
    }

    private static final void initView$lambda-5(ClientOperationActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openFileManager(1002);
    }

    private static final void initView$lambda-7(ClientOperationActivity this$0, Boolean update) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)update, (String)"update");
        if (update.booleanValue()) {
            RecyclerView recyclerView = this$0.recyclerView;
            if (recyclerView != null) {
                RecyclerView.Adapter adapter = recyclerView.getAdapter();
                if (adapter != null) {
                    adapter.notifyDataSetChanged();
                }
            }
        }
    }

    private static final void initView$lambda-8(ProgressBean it) {
        if (it.getProgress() != 100 || it.getCurrentTotalBytes() == it.getTotalSize()) {
            // empty if block
        }
    }

    private static final void sendMoreFile$lambda-13$lambda-11(String it) {
    }

    private static final void sendMoreFile$lambda-13$lambda-12(Throwable error) {
        Log.d((String)"WebServer", (String)error.toString());
    }
}

