/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xshare.base.net.util.GsonUtils;
import com.xshare.business.utils.CommonConstants;
import com.xshare.business.utils.MD5Utils;
import com.xshare.room.impl.RoomServiceImpl;
import com.xshare.trans.R;
import com.xshare.webserver.FileDataManager;
import com.xshare.webserver.ServerOperationActivity;
import com.xshare.webserver.TransferInterfaceManager;
import com.xshare.webserver.WebServerManager;
import com.xshare.webserver.adapter.FileListAdapter;
import com.xshare.webserver.bean.FileInfoBean;
import com.xshare.webserver.bean.MessageBean;
import com.xshare.webserver.http.ApiService;
import com.xshare.webserver.http.RetrofitCommonManager;
import com.xshare.webserver.utils.Constants;
import com.xshare.webserver.utils.FileUtils;
import com.yanzhenjie.andserver.bean.ProgressBean;
import com.yanzhenjie.andserver.util.IOUtils;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\"\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\fH\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\b\u0010\u0019\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/xshare/webserver/ServerOperationActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "TAG", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "setRecyclerView", "(Landroidx/recyclerview/widget/RecyclerView;)V", "checkPermission", "", "initView", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "openFileManager", "sendMoreFile", "app_release"})
public final class ServerOperationActivity
extends AppCompatActivity {
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();
    @NotNull
    private final String TAG;
    @Nullable
    private RecyclerView recyclerView;

    public ServerOperationActivity() {
        this.TAG = "ServerOperationActivity";
    }

    @Nullable
    public final RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public final void setRecyclerView(@Nullable RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_server_operation);
        this.checkPermission();
        this.initView();
    }

    private final void initView() {
        ((Button)this.findViewById(R.id.bt_success)).setOnClickListener(ServerOperationActivity::initView$lambda-0);
        ((Button)this.findViewById(R.id.bt_continuation)).setOnClickListener(ServerOperationActivity::initView$lambda-1);
        ((Button)this.findViewById(R.id.bt_disconnect)).setOnClickListener(ServerOperationActivity::initView$lambda-2);
        ((Button)this.findViewById(R.id.bt_send_more)).setOnClickListener(arg_0 -> ServerOperationActivity.initView$lambda-3(this, arg_0));
        RecyclerView recyclerView = this.recyclerView = (RecyclerView)this.findViewById(R.id.list_file);
        if (recyclerView != null) {
            RecyclerView recyclerView2;
            RecyclerView $this$initView_u24lambda_u2d4 = recyclerView2 = recyclerView;
            boolean bl = false;
            $this$initView_u24lambda_u2d4.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
            $this$initView_u24lambda_u2d4.setAdapter((RecyclerView.Adapter)new FileListAdapter((Context)this, (List<FileInfoBean>)FileDataManager.INSTANCE.getSendFileData()));
        }
        FileDataManager.INSTANCE.getReceiveDataUpdate().observe((LifecycleOwner)this, arg_0 -> ServerOperationActivity.initView$lambda-5(this, arg_0));
        WebServerManager.INSTANCE.isSucceed().observe((LifecycleOwner)this, arg_0 -> ServerOperationActivity.initView$lambda-6(this, arg_0));
        IOUtils.progress.observe((LifecycleOwner)this, ServerOperationActivity::initView$lambda-7);
    }

    private final void sendMoreFile() {
        String string2 = Constants.INSTANCE.getBaseUrl();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            RetrofitCommonManager.Companion.getInstance().getApiService(ApiService.class, it).sendMoreFile(GsonUtils.toJson(FileDataManager.INSTANCE.getSendMoreFiles()), true).subscribeOn(Schedulers.io()).subscribe(ServerOperationActivity::sendMoreFile$lambda-10$lambda-8, arg_0 -> ServerOperationActivity.sendMoreFile$lambda-10$lambda-9(this, arg_0));
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private final void openFileManager(int requestCode) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        this.startActivityForResult(intent, requestCode);
    }

    private final void checkPermission() {
        if (Build.VERSION.SDK_INT <= 29) {
            int i = ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (i != 0) {
                String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.ACCESS_FINE_LOCATION"};
                ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])stringArray, (int)100);
            }
        } else if (!Environment.isExternalStorageManager()) {
            Intent intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
            intent.setData(Uri.parse((String)Intrinsics.stringPlus((String)"package:", (Object)this.getPackageName())));
            this.startActivityForResult(intent, 1003);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1002 && resultCode == -1) {
            Uri uri;
            Intent intent = data;
            Uri uri2 = uri = intent == null ? null : intent.getData();
            if (uri2 != null) {
                String string2;
                Uri it = uri2;
                boolean bl = false;
                FileDataManager.INSTANCE.getSendMoreFiles().clear();
                FileUtils fileUtils = FileUtils.Companion.getInstance((Context)this);
                String path = fileUtils == null ? null : fileUtils.getChooseFileResultPath(it);
                Toast.makeText((Context)((Context)this), (CharSequence)path, (int)1).show();
                String fileMD5 = MD5Utils.getFileMD5(path);
                FileInfoBean fileInfoBean = new FileInfoBean();
                fileInfoBean.setServer(true);
                String string3 = path;
                if (string3 == null) {
                    string2 = null;
                } else {
                    String string4 = string3.substring(StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                }
                fileInfoBean.setFileName(string2);
                fileInfoBean.setFilePath(path);
                fileInfoBean.setSize(new File(path).length());
                fileInfoBean.setFileMD5(fileMD5);
                fileInfoBean.setGaid(CommonConstants.INSTANCE.getGAID());
                FileDataManager.INSTANCE.getSendMoreFiles().add(fileInfoBean);
                FileDataManager.INSTANCE.getSendFileData().add(fileInfoBean);
                RoomServiceImpl.INSTANCE.insertSendFileData(fileInfoBean);
                RecyclerView recyclerView = this.getRecyclerView();
                if (recyclerView != null) {
                    RecyclerView.Adapter adapter = recyclerView.getAdapter();
                    if (adapter != null) {
                        adapter.notifyDataSetChanged();
                    }
                }
                this.sendMoreFile();
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        FileDataManager.INSTANCE.getSendFileData().clear();
        FileDataManager.INSTANCE.getReceiveFileData().clear();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 == null) {
                view = null;
            } else {
                map.put(id2, view2);
                view = view2;
            }
        }
        return view;
    }

    private static final void initView$lambda-0(View it) {
        RoomServiceImpl.INSTANCE.querySendFileSuccessData((Function1<? super List<FileInfoBean>, Unit>)((Function1)initView.1.1.INSTANCE));
        RoomServiceImpl.INSTANCE.queryReceiveFileSuccessData((Function1<? super List<FileInfoBean>, Unit>)((Function1)initView.1.2.INSTANCE));
    }

    private static final void initView$lambda-1(View it) {
        RoomServiceImpl.INSTANCE.queryReceiveFileData((Function1<? super List<FileInfoBean>, Unit>)((Function1)initView.2.1.INSTANCE));
    }

    private static final void initView$lambda-2(View it) {
        TransferInterfaceManager.INSTANCE.heartbeatMessage(new MessageBean(201, 324001L, "", false, ""));
        WebServerManager.INSTANCE.shutdownServer();
    }

    private static final void initView$lambda-3(ServerOperationActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openFileManager(1002);
    }

    private static final void initView$lambda-5(ServerOperationActivity this$0, Boolean update) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)update, (String)"update");
        if (update.booleanValue()) {
            RecyclerView recyclerView = this$0.recyclerView;
            if (recyclerView != null) {
                RecyclerView.Adapter adapter = recyclerView.getAdapter();
                if (adapter != null) {
                    adapter.notifyDataSetChanged();
                }
            }
        }
    }

    private static final void initView$lambda-6(ServerOperationActivity this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Integer n = it;
        boolean bl = false;
        if (n != null && n == 0) {
            Toast.makeText((Context)((Context)this$0), (CharSequence)"\u94fe\u63a5\u5df2\u65ad\u5f00", (int)0).show();
            this$0.finish();
        }
    }

    private static final void initView$lambda-7(ProgressBean it) {
        if (it.getProgress() != 100 || it.getCurrentTotalBytes() == it.getTotalSize()) {
            // empty if block
        }
    }

    private static final void sendMoreFile$lambda-10$lambda-8(String it) {
    }

    private static final void sendMoreFile$lambda-10$lambda-9(ServerOperationActivity this$0, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Log.d((String)this$0.TAG, (String)error.toString());
    }
}

