/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver;

import android.content.Context;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.yanzhenjie.andserver.AndServer;
import com.yanzhenjie.andserver.Server;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/xshare/webserver/WebServerManager;", "", "()V", "TAG", "", "isSucceed", "Landroidx/lifecycle/MutableLiveData;", "", "()Landroidx/lifecycle/MutableLiveData;", "webSerVer", "Lcom/yanzhenjie/andserver/Server;", "shutdownServer", "", "startWebServer", "context", "Landroid/content/Context;", "port", "app_release"})
public final class WebServerManager {
    @NotNull
    public static final WebServerManager INSTANCE = new WebServerManager();
    @NotNull
    private static final String TAG = "WebServerManager";
    @Nullable
    private static Server webSerVer;
    @NotNull
    private static final MutableLiveData<Integer> isSucceed;

    private WebServerManager() {
    }

    @NotNull
    public final MutableLiveData<Integer> isSucceed() {
        return isSucceed;
    }

    public final void startWebServer(@NotNull Context context, int port) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (webSerVer == null) {
            webSerVer = AndServer.webServer(context).port(port).timeout(10, TimeUnit.SECONDS).listener(new Server.ServerListener(){

                public void onStarted() {
                    WebServerManager.INSTANCE.isSucceed().postValue((Object)1);
                }

                public void onStopped() {
                    WebServerManager.INSTANCE.isSucceed().postValue((Object)0);
                }

                public void onException(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Log.d((String)"WebServerManager", (String)String.valueOf(e.getMessage()));
                    WebServerManager.INSTANCE.isSucceed().postValue((Object)-1);
                }
            }).build();
        }
        Server server = webSerVer;
        if (server != null) {
            server.startup();
        }
    }

    public final void shutdownServer() {
        Integer n = (Integer)isSucceed.getValue();
        int n2 = 1;
        if (n != null && n == n2) {
            Server server = webSerVer;
            if (server != null) {
                server.shutdown();
            }
        }
    }

    static {
        isSucceed = new MutableLiveData();
    }
}

