/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.xshare.business.utils.LogUtils;
import com.xshare.trans.R;
import com.xshare.webserver.bean.FileInfoBean;
import com.yanzhenjie.andserver.bean.ProgressBean;
import com.yanzhenjie.andserver.util.IOUtils;
import io.reactivex.disposables.Disposable;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u001c\u0010\u0011\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/xshare/webserver/adapter/FileListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/xshare/webserver/adapter/FileListAdapter$ItemViewHolder;", "context", "Landroid/content/Context;", "dataList", "", "Lcom/xshare/webserver/bean/FileInfoBean;", "(Landroid/content/Context;Ljava/util/List;)V", "getContext", "()Landroid/content/Context;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "ItemViewHolder", "app_release"})
public final class FileListAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    @NotNull
    private final Context context;
    @NotNull
    private final List<FileInfoBean> dataList;

    public FileListAdapter(@NotNull Context context, @NotNull List<FileInfoBean> dataList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        this.context = context;
        this.dataList = dataList;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public ItemViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.file_list_item_layout, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        return new ItemViewHolder(view);
    }

    public void onBindViewHolder(@NotNull ItemViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bindView(this.dataList.get(position));
    }

    public int getItemCount() {
        return this.dataList.size();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0006\u0010\u001e\u001a\u00020\u001bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n0\rR\u00060\u0000R\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/xshare/webserver/adapter/FileListAdapter$ItemViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Lcom/xshare/webserver/adapter/FileListAdapter;Landroid/view/View;)V", "bt_download", "Landroid/widget/Button;", "currentBytes", "", "currentSystemTime", "display", "Lio/reactivex/disposables/Disposable;", "myRunnable", "Lcom/xshare/webserver/adapter/FileListAdapter$ItemViewHolder$MyRunnable;", "Lcom/xshare/webserver/adapter/FileListAdapter;", "getMyRunnable", "()Lcom/xshare/webserver/adapter/FileListAdapter$ItemViewHolder$MyRunnable;", "myRunnable$delegate", "Lkotlin/Lazy;", "pbProgress", "Landroid/widget/ProgressBar;", "progress", "", "tvFileName", "Landroid/widget/TextView;", "tvProgress", "bindView", "", "fileInfoBean", "Lcom/xshare/webserver/bean/FileInfoBean;", "refreshViewProgress", "MyRunnable", "app_release"})
    public final class ItemViewHolder
    extends RecyclerView.ViewHolder {
        @Nullable
        private TextView tvFileName;
        @Nullable
        private TextView tvProgress;
        @Nullable
        private ProgressBar pbProgress;
        @Nullable
        private Button bt_download;
        @Nullable
        private Disposable display;
        private long currentBytes;
        private int progress;
        @NotNull
        private final Lazy myRunnable$delegate;
        private long currentSystemTime;

        public ItemViewHolder(View view) {
            Intrinsics.checkNotNullParameter((Object)((Object)FileListAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
            this.myRunnable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MyRunnable>(this){
                final /* synthetic */ ItemViewHolder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MyRunnable invoke() {
                    return this.this$0.new MyRunnable();
                }
            }));
            this.tvFileName = (TextView)view.findViewById(R.id.tv_file_name);
            this.tvProgress = (TextView)view.findViewById(R.id.tv_progress);
            this.pbProgress = (ProgressBar)view.findViewById(R.id.pb_progress);
            this.bt_download = (Button)view.findViewById(R.id.bt_download);
        }

        private final MyRunnable getMyRunnable() {
            Lazy lazy = this.myRunnable$delegate;
            return (MyRunnable)lazy.getValue();
        }

        @SuppressLint(value={"CheckResult"})
        public final void bindView(@NotNull FileInfoBean fileInfoBean) {
            Intrinsics.checkNotNullParameter((Object)fileInfoBean, (String)"fileInfoBean");
            TextView textView = this.tvFileName;
            if (textView != null) {
                textView.setText((CharSequence)fileInfoBean.getFileName());
            }
            IOUtils.progress.observe((LifecycleOwner)((AppCompatActivity)FileListAdapter.this.getContext()), arg_0 -> ItemViewHolder.bindView$lambda-0(this, fileInfoBean, arg_0));
            this.refreshViewProgress();
        }

        public final void refreshViewProgress() {
            ProgressBar progressBar = this.pbProgress;
            if (progressBar != null) {
                progressBar.postDelayed((Runnable)this.getMyRunnable(), 1500L);
            }
        }

        private static final void bindView$lambda-0(ItemViewHolder this$0, FileInfoBean $fileInfoBean, ProgressBean it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$fileInfoBean, (String)"$fileInfoBean");
            if (this$0.currentSystemTime == 0L) {
                this$0.currentSystemTime = System.currentTimeMillis();
                LogUtils.d("DownLoadFile", Intrinsics.stringPlus((String)$fileInfoBean.getFileName(), (Object)"  file download start"));
            }
            if (Intrinsics.areEqual((Object)it.getPath(), (Object)$fileInfoBean.getFilePath())) {
                if ($fileInfoBean.isFolder()) {
                    if (it.getProgress() == 100) {
                        this$0.currentBytes += it.getCurrentTotalBytes();
                        int n = this$0.progress = this$0.currentBytes <= $fileInfoBean.getSize() ? (int)(this$0.currentBytes * (long)100 / $fileInfoBean.getSize()) : 100;
                        if (this$0.progress == 100) {
                            LogUtils.d("DownLoadFile", $fileInfoBean.getFileName() + " file download end duration == " + (System.currentTimeMillis() - this$0.currentSystemTime));
                        }
                    }
                } else {
                    this$0.progress = it.getProgress();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/xshare/webserver/adapter/FileListAdapter$ItemViewHolder$MyRunnable;", "Ljava/lang/Runnable;", "(Lcom/xshare/webserver/adapter/FileListAdapter$ItemViewHolder;)V", "run", "", "app_release"})
        public final class MyRunnable
        implements Runnable {
            public MyRunnable() {
                Intrinsics.checkNotNullParameter((Object)((Object)ItemViewHolder.this), (String)"this$0");
            }

            @Override
            public void run() {
                ProgressBar progressBar = ItemViewHolder.this.pbProgress;
                if (progressBar != null) {
                    progressBar.setProgress(ItemViewHolder.this.progress);
                }
                TextView textView = ItemViewHolder.this.tvProgress;
                if (textView != null) {
                    textView.setText((CharSequence)("" + ItemViewHolder.this.progress + '%'));
                }
                if (ItemViewHolder.this.progress != 100) {
                    ItemViewHolder.this.refreshViewProgress();
                }
            }
        }
    }
}

