/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.controller;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.xshare.base.net.util.GsonUtils;
import com.xshare.webserver.FileDataManager;
import com.xshare.webserver.MessageManager;
import com.xshare.webserver.bean.FileInfoBean;
import com.xshare.webserver.utils.BufferedRandomAccessFile;
import com.yanzhenjie.andserver.annotation.FormPart;
import com.yanzhenjie.andserver.framework.body.FileBody;
import com.yanzhenjie.andserver.framework.body.JsonBody;
import com.yanzhenjie.andserver.framework.body.StreamBody;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.http.multipart.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;

public class FileController {
    public static final String filePath = Environment.getExternalStorageDirectory() + File.separator + "CowcatServer";
    public static String host = "";

    @Deprecated
    String uploadFile(HttpRequest request, HttpResponse response, @FormPart(name="fileName") MultipartFile file) {
        try {
            int len;
            Long time = System.currentTimeMillis();
            long downloadByte = 0L;
            long totalByte = file.getSize();
            File uploadFile = this.createUploadFile(file);
            byte[] buffer = new byte[8192];
            BufferedRandomAccessFile randomAccessFile = new BufferedRandomAccessFile(uploadFile, "rw");
            randomAccessFile.seek(uploadFile.length());
            InputStream inputStream = file.getStream();
            while ((len = inputStream.read(buffer)) != -1) {
                randomAccessFile.write(buffer, 0, len);
                downloadByte += (long)len;
            }
            randomAccessFile.close();
            Log.d((String)"uploadFile", (String)("uploadFile time==" + (System.currentTimeMillis() - time)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "\u4e0a\u4f20\u6210\u529f";
    }

    public File createUploadFile(MultipartFile file) throws IOException {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File secondDir = new File(filePath);
            return new File(secondDir, file.getFilename());
        }
        return null;
    }

    public ResponseBody downloadFile(HttpRequest request, HttpResponse response, String directoryPath, String filePath) {
        Log.d((String)"downloadFile", (String)("directoryPath==" + directoryPath + "  filePath == " + filePath));
        try {
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                long rangeStartPosition = 0L;
                long rangeEndPosition = 0L;
                boolean rangFlag = false;
                File file = new File(filePath);
                RandomAccessFile randomAccessFile = new RandomAccessFile(filePath, "r");
                if (request.getHeaderNames().contains("Range")) {
                    String strRange = request.getHeader("Range").replaceAll("bytes=", "");
                    if (strRange.contains("-")) {
                        String[] rg = strRange.split("-");
                        if (rg.length > 1) {
                            rangeStartPosition = Long.parseLong(rg[0]);
                            rangeEndPosition = Long.parseLong(rg[1]);
                        } else {
                            rangeStartPosition = Long.parseLong(strRange.replaceAll("-", ""));
                            rangeEndPosition = file.length();
                        }
                    } else {
                        rangeStartPosition = Long.parseLong(strRange);
                        rangeEndPosition = file.length();
                    }
                    if (rangeStartPosition > 0L) {
                        rangFlag = true;
                    }
                } else {
                    rangeEndPosition = file.length();
                }
                if (rangeEndPosition > file.length()) {
                    rangeEndPosition = file.length();
                }
                if (rangeStartPosition > rangeEndPosition) {
                    rangeStartPosition = rangeEndPosition;
                }
                if (rangFlag) {
                    randomAccessFile.seek(rangeStartPosition);
                } else {
                    randomAccessFile.seek(0L);
                }
                long totalSize = rangeStartPosition == 0L && rangeEndPosition == randomAccessFile.length() ? randomAccessFile.length() : (rangeEndPosition == rangeStartPosition ? 0L : rangeEndPosition - rangeStartPosition);
                if (totalSize > file.length()) {
                    totalSize = file.length();
                }
                response.setStatus(200);
                if (rangFlag) {
                    if (!TextUtils.isEmpty((CharSequence)directoryPath)) {
                        return new StreamBody(directoryPath, Channels.newInputStream(randomAccessFile.getChannel()), totalSize);
                    }
                    return new StreamBody(filePath, Channels.newInputStream(randomAccessFile.getChannel()), totalSize);
                }
                if (!TextUtils.isEmpty((CharSequence)directoryPath)) {
                    return new FileBody(file, directoryPath);
                }
                return new FileBody(file);
            }
            return null;
        }
        catch (Exception e) {
            Log.d((String)"downloadFile", (String)e.getMessage());
            return null;
        }
    }

    String queryMessage(HttpRequest request, HttpResponse response, String message) {
        MessageManager.INSTANCE.parseMessage(message);
        return "200";
    }

    String progressMessage(HttpRequest request, HttpResponse response, String currentProgress) {
        return "\u6210\u529f";
    }

    public ResponseBody getFileList(HttpRequest request, HttpResponse response) {
        ArrayList<FileInfoBean> selectFileData = new ArrayList<FileInfoBean>();
        selectFileData.addAll(FileDataManager.INSTANCE.getSendFileData());
        String json = GsonUtils.toJson(selectFileData);
        return new JsonBody(json);
    }

    public String sendMoreFile(HttpRequest request, HttpResponse response, String sendMoreFiles, String isServer) {
        try {
            boolean value = Boolean.parseBoolean(isServer);
            FileDataManager.INSTANCE.paresSendMoreFiles(sendMoreFiles, value);
            return "200";
        }
        catch (Exception e) {
            return "\u670d\u52a1\u7aef\u89e3\u6790\u6570\u636e\u5931\u8d25";
        }
    }
}

