/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.http;

import android.accounts.NetworkErrorException;
import androidx.annotation.NonNull;
import com.xshare.webserver.http.BaseResponse;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;

public abstract class BaseObserver<T>
implements Observer<BaseResponse<T>> {
    public void onComplete() {
    }

    public void onSubscribe(@NonNull Disposable d) {
        this.onDisposable(d);
    }

    public void onError(Throwable e) {
        if (e instanceof ConnectException || e instanceof TimeoutException || e instanceof NetworkErrorException || e instanceof UnknownHostException) {
            try {
                this.onFailure(e, false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            try {
                this.onFailure(e, true);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void onNext(BaseResponse<T> baseResponse) {
        this.onRequestSuccess(baseResponse);
    }

    public abstract void onRequestSuccess(BaseResponse<T> var1);

    public abstract void onFailure(Throwable var1, boolean var2) throws Exception;

    public abstract Disposable onDisposable(Disposable var1);
}

