/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.http.response;

import android.net.Uri;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.webserver.http.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final ProgressListener progressListener;
    private BufferedSource bufferedSource;

    public ProgressResponseBody(ResponseBody responseBody, ProgressListener progressListener, String filePath) {
        this.responseBody = responseBody;
        this.progressListener = progressListener;
        progressListener.onStart(responseBody);
    }

    private void writeFileToDisk(ResponseBody responseBody, String filePath) throws IOException {
        int len;
        long time = System.currentTimeMillis();
        long totalByte = responseBody.contentLength();
        long downloadByte = 0L;
        File file = new File(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedInputStream inbuff = null;
        BufferedOutputStream bos = null;
        OutputStream os = BaseApplication.getContext().getContentResolver().openOutputStream(Uri.fromFile((File)file), "wa");
        byte[] buffer = new byte[16384];
        inbuff = new BufferedInputStream(responseBody.byteStream(), buffer.length);
        bos = new BufferedOutputStream(os, buffer.length);
        while ((len = inbuff.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
            this.progressListener.onProgress(downloadByte += (long)len, totalByte);
        }
        bos.flush();
        bos.close();
        inbuff.close();
        Log.d((String)"DownFiletime", (String)("duration==" + (System.currentTimeMillis() - time)));
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                if (ProgressResponseBody.this.progressListener != null) {
                    ProgressResponseBody.this.progressListener.onProgress(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength());
                }
                return bytesRead;
            }
        };
    }
}

