/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.impl;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import androidx.lifecycle.MutableLiveData;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.CommonConstants;
import com.xshare.webserver.ClientOperationActivity;
import com.xshare.webserver.FileDataManager;
import com.xshare.webserver.WebServerManager;
import com.xshare.webserver.bean.FileInfoBean;
import com.xshare.webserver.utils.Constants;
import com.xshare.webserver.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0014"}, d2={"Lcom/xshare/webserver/impl/WebServiceImpl;", "", "()V", "setAppFilesData", "", "packageName", "", "setConnectIp", "context", "Landroid/content/Context;", "ip", "port", "", "setSendDirectoryData", "directoryPath", "setSendFilesData", "filePath", "startWebServer", "Landroidx/lifecycle/MutableLiveData;", "stopWebSerVer", "app_release"})
public final class WebServiceImpl {
    @NotNull
    public static final WebServiceImpl INSTANCE = new WebServiceImpl();

    private WebServiceImpl() {
    }

    @NotNull
    public final MutableLiveData<Integer> startWebServer(@NotNull Context context, int port) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WebServerManager.INSTANCE.startWebServer(context, port);
        return WebServerManager.INSTANCE.isSucceed();
    }

    public final void stopWebSerVer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WebServerManager.INSTANCE.shutdownServer();
    }

    public final void setConnectIp(@NotNull Context context, @NotNull String ip, int port) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Constants.INSTANCE.setBaseUrl("http://" + ip + ':' + port);
        context.startActivity(new Intent(context, ClientOperationActivity.class));
    }

    public final void setSendFilesData(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileInfoBean fileInfoBean = new FileInfoBean();
        fileInfoBean.setServer(true);
        String string2 = filePath.substring(StringsKt.lastIndexOf$default((CharSequence)filePath, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        fileInfoBean.setFileName(string2);
        fileInfoBean.setFilePath(filePath);
        FileDataManager.INSTANCE.getSendFileData().add(fileInfoBean);
    }

    public final void setAppFilesData(@NotNull String packageName) {
        FileInfoBean appInfo;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        PackageManager packageManager = BaseApplication.Companion.getBaseApplication().getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"BaseApplication.baseApplication.packageManager");
        FileInfoBean fileInfoBean = appInfo = FileUtils.Companion.getAppInfo(packageName, packageManager);
        if (fileInfoBean != null) {
            fileInfoBean.setServer(true);
        }
        FileInfoBean fileInfoBean2 = appInfo;
        if (fileInfoBean2 != null) {
            FileInfoBean it = fileInfoBean2;
            boolean bl = false;
            FileDataManager.INSTANCE.getSendFileData().add(it);
        }
    }

    public final void setSendDirectoryData(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        File file = new File(directoryPath);
        if (file.exists()) {
            ArrayList<File> files;
            FileInfoBean fileInfoBean = new FileInfoBean();
            fileInfoBean.setFolder(true);
            fileInfoBean.setServer(true);
            fileInfoBean.setFileName(FileUtils.Companion.getDirectoryName(directoryPath));
            fileInfoBean.setFilePath(directoryPath);
            ArrayList<File> arrayList = files = FileUtils.Companion.filesOfDirectory(file);
            if (arrayList != null) {
                ArrayList<File> it = arrayList;
                boolean bl = false;
                ArrayList<FileInfoBean> fileList = new ArrayList<FileInfoBean>();
                long totalSize = 0L;
                Iterable $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file2 = (File)element$iv;
                    boolean bl2 = false;
                    FileInfoBean childFileInfo = new FileInfoBean();
                    childFileInfo.setFolder(false);
                    childFileInfo.setServer(true);
                    String string2 = file2.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
                    String string3 = file2.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.absolutePath");
                    String string4 = string2.substring(StringsKt.lastIndexOf$default((CharSequence)string3, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    childFileInfo.setFileName(string4);
                    childFileInfo.setFilePath(file2.getAbsolutePath());
                    childFileInfo.setSize(file2.length());
                    fileInfoBean.setGaid(CommonConstants.INSTANCE.getGAID());
                    totalSize += childFileInfo.getSize();
                    fileList.add(childFileInfo);
                }
                fileInfoBean.setSize(totalSize);
                fileInfoBean.setChildFiles((List<FileInfoBean>)fileList);
                FileDataManager.INSTANCE.getSendFileData().add(fileInfoBean);
            }
        }
    }
}

