/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.xshare.business.utils.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class BitmapUtil {
    public static final String APP_THUMBNAIL = "AppThumbnail";
    private static final int ICON_WIDTH = 144;
    public static final int ASSISTANT_ICON_WIDTH = 48;
    private static final int ICON_QUALITY = 100;
    private static final String TAG = BitmapUtil.class.getName();

    public static String getAppBundleIconExist(Context context, String appName) {
        String fileName;
        String root = context.getFilesDir().getAbsolutePath();
        File appDir = new File(root, APP_THUMBNAIL);
        File file = new File(appDir, fileName = appName + ".png");
        if (file != null && file.exists()) {
            return file.getPath();
        }
        return "";
    }

    public static String saveBitmap(Context context, String packageName, Drawable drawable2) {
        return BitmapUtil.saveBitmap(context, packageName, drawable2, 144, 144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveBitmap(Context context, String packageName, Drawable drawable2, int iconWidth, int iconHeight) {
        String root = context.getFilesDir().getAbsolutePath();
        File appDir = new File(root, APP_THUMBNAIL);
        if (!appDir.exists()) {
            appDir.mkdirs();
        }
        String fileName = packageName + ".png";
        File file = new File(appDir, fileName);
        FileOutputStream fos = null;
        Bitmap bitmap = null;
        try {
            bitmap = Glide.get((Context)context.getApplicationContext()).getBitmapPool().get(iconWidth, iconHeight, Bitmap.Config.ARGB_8888);
            fos = new FileOutputStream(file);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, iconWidth, iconHeight);
            drawable2.draw(canvas);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            fos.flush();
            String string2 = file.getAbsolutePath();
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] Bitmap2Bytes(Bitmap bm) {
        if (bm == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap Bytes2Bimap(byte[] b) {
        if (b.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
    }

    public static Bitmap drawable2Bitmap(Context context, Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        int w = drawable2.getIntrinsicWidth();
        int h = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Glide.get((Context)context.getApplicationContext()).getBitmapPool().get(w, h, config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, w, h);
        drawable2.draw(canvas);
        return bitmap;
    }

    public static Bitmap drawable2Bitmap(Drawable drawable2) {
        Bitmap.Config config;
        if (drawable2 == null) {
            return null;
        }
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        if (Build.VERSION.SDK_INT >= 26 && drawable2 instanceof AdaptiveIconDrawable) {
            config = Bitmap.Config.ARGB_8888;
        } else {
            Bitmap.Config config2 = config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        }
        if (width > 0 && height > 0) {
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, width, height);
            drawable2.draw(canvas);
            return bitmap;
        }
        return null;
    }

    public static Drawable bitmap2Drawable(Bitmap bm) {
        if (bm == null) {
            return null;
        }
        return new BitmapDrawable(bm);
    }

    public static Bitmap drawbale2Bitmap(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 26 && drawable2 instanceof AdaptiveIconDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            return bitmap;
        }
        return ((BitmapDrawable)drawable2).getBitmap();
    }

    public static Bitmap parseBitmap(Context context, byte[] data) {
        LogUtils.d(TAG, "parseBitmap data = " + data);
        if (data == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, 8);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int width = intBuffer.get();
        int height = intBuffer.get();
        byteBuffer = ByteBuffer.wrap(data, 8, data.length - 8);
        intBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        int[] pixels = new int[intBuffer.remaining()];
        intBuffer.get(pixels);
        Bitmap bitmap = null;
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            LogUtils.d(TAG, "parseBitmap bitmap = " + bitmap);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("parseBitmap:IllegalArgumentException  e = " + e));
            return null;
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBitmapByte(Context context, String apkIconPath) {
        LogUtils.d(TAG, "getBitmapByte:" + apkIconPath);
        if (TextUtils.isEmpty((CharSequence)apkIconPath)) {
            return null;
        }
        Bitmap bitmap = null;
        ByteBuffer byteBuffer = null;
        try {
            byte[] bytesArray;
            bitmap = BitmapFactory.decodeFile((String)apkIconPath);
            if (bitmap == null) {
                byte[] byArray = null;
                return byArray;
            }
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            byteBuffer = ByteBuffer.allocate((pixels.length + 2) * 4);
            IntBuffer intBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN).asIntBuffer();
            intBuffer.put(width);
            intBuffer.put(height);
            intBuffer.put(pixels);
            byte[] byArray = bytesArray = byteBuffer.array();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.clear();
            }
            if (bitmap != null && !bitmap.isRecycled()) {
                Glide.get((Context)context.getApplicationContext()).getBitmapPool().put(bitmap);
            }
        }
    }

    public static boolean drawableCanUse(Drawable drawable2) {
        try {
            if (drawable2 instanceof BitmapDrawable) {
                BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
                return bitmapDrawable.getBitmap() != null && !bitmapDrawable.getBitmap().isRecycled();
            }
            if (Build.VERSION.SDK_INT >= 26 && drawable2 instanceof AdaptiveIconDrawable) {
                Drawable backgroundDr = ((AdaptiveIconDrawable)drawable2).getBackground();
                Drawable foregroundDr = ((AdaptiveIconDrawable)drawable2).getForeground();
                if (foregroundDr instanceof BitmapDrawable) {
                    BitmapDrawable forgBitmap = (BitmapDrawable)foregroundDr;
                    return backgroundDr != null && foregroundDr != null && forgBitmap != null && !forgBitmap.getBitmap().isRecycled();
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

